/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.cmdline.ObjectStreamFactory;
import chalk.tools.formats.BioNLP2004NameSampleStreamFactory;
import chalk.tools.formats.ChunkerSampleStreamFactory;
import chalk.tools.formats.Conll02NameSampleStreamFactory;
import chalk.tools.formats.Conll03NameSampleStreamFactory;
import chalk.tools.formats.ConllXPOSSampleStreamFactory;
import chalk.tools.formats.ConllXSentenceSampleStreamFactory;
import chalk.tools.formats.ConllXTokenSampleStreamFactory;
import chalk.tools.formats.DocumentSampleStreamFactory;
import chalk.tools.formats.LeipzigDocumentSampleStreamFactory;
import chalk.tools.formats.NameSampleDataStreamFactory;
import chalk.tools.formats.SentenceSampleStreamFactory;
import chalk.tools.formats.TokenSampleStreamFactory;
import chalk.tools.formats.WordTagSampleStreamFactory;
import chalk.tools.formats.ad.ADChunkSampleStreamFactory;
import chalk.tools.formats.ad.ADNameSampleStreamFactory;
import chalk.tools.formats.ad.ADPOSSampleStreamFactory;
import chalk.tools.formats.ad.ADSentenceSampleStreamFactory;
import chalk.tools.formats.ad.ADTokenSampleStreamFactory;
import chalk.tools.formats.convert.NameToSentenceSampleStreamFactory;
import chalk.tools.formats.convert.NameToTokenSampleStreamFactory;
import chalk.tools.formats.convert.POSToSentenceSampleStreamFactory;
import chalk.tools.formats.convert.POSToTokenSampleStreamFactory;
import java.util.HashMap;
import java.util.Map;

public final class StreamFactoryRegistry {
    private static final Map<Class, Map<String, ObjectStreamFactory>> registry = new HashMap<Class, Map<String, ObjectStreamFactory>>();
    public static final String DEFAULT_FORMAT = "opennlp";

    private StreamFactoryRegistry() {
    }

    public static boolean registerFactory(Class clazz, String string, ObjectStreamFactory objectStreamFactory) {
        boolean bl;
        Map<String, ObjectStreamFactory> map = registry.get(clazz);
        if (null == map) {
            map = new HashMap<String, ObjectStreamFactory>();
        }
        if (!map.containsKey(string)) {
            map.put(string, objectStreamFactory);
            registry.put(clazz, map);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static void unregisterFactory(Class clazz, String string) {
        Map<String, ObjectStreamFactory> map = registry.get(clazz);
        if (null != map && map.containsKey(string)) {
            map.remove(string);
        }
    }

    public static <T> Map<String, ObjectStreamFactory<T>> getFactories(Class<T> clazz) {
        return registry.get(clazz);
    }

    public static <T> ObjectStreamFactory<T> getFactory(Class<T> clazz, String string) {
        ObjectStreamFactory objectStreamFactory;
        if (null == string) {
            string = DEFAULT_FORMAT;
        }
        ObjectStreamFactory objectStreamFactory2 = objectStreamFactory = registry.containsKey(clazz) ? registry.get(clazz).get(string) : null;
        if (objectStreamFactory != null) {
            return objectStreamFactory;
        }
        try {
            Class<?> clazz2 = Class.forName(string);
            try {
                return (ObjectStreamFactory)clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static {
        ChunkerSampleStreamFactory.registerFactory();
        DocumentSampleStreamFactory.registerFactory();
        NameSampleDataStreamFactory.registerFactory();
        SentenceSampleStreamFactory.registerFactory();
        TokenSampleStreamFactory.registerFactory();
        WordTagSampleStreamFactory.registerFactory();
        NameToSentenceSampleStreamFactory.registerFactory();
        NameToTokenSampleStreamFactory.registerFactory();
        POSToSentenceSampleStreamFactory.registerFactory();
        POSToTokenSampleStreamFactory.registerFactory();
        BioNLP2004NameSampleStreamFactory.registerFactory();
        Conll02NameSampleStreamFactory.registerFactory();
        Conll03NameSampleStreamFactory.registerFactory();
        ConllXPOSSampleStreamFactory.registerFactory();
        ConllXSentenceSampleStreamFactory.registerFactory();
        ConllXTokenSampleStreamFactory.registerFactory();
        LeipzigDocumentSampleStreamFactory.registerFactory();
        ADChunkSampleStreamFactory.registerFactory();
        ADNameSampleStreamFactory.registerFactory();
        ADSentenceSampleStreamFactory.registerFactory();
        ADPOSSampleStreamFactory.registerFactory();
        ADTokenSampleStreamFactory.registerFactory();
    }
}

