/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.ChunkerCrossValidator;
import chalk.tools.chunker.ChunkerEvaluationMonitor;
import chalk.tools.chunker.ChunkerFactory;
import chalk.tools.cmdline.AbstractCrossValidatorTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import chalk.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import chalk.tools.cmdline.chunker.TrainingParams;
import chalk.tools.cmdline.params.CVParams;
import chalk.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;
import java.util.LinkedList;

public final class ChunkerCrossValidatorTool
extends AbstractCrossValidatorTool<ChunkSample, CVToolParams> {
    public ChunkerCrossValidatorTool() {
        super(ChunkSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the chunker";
    }

    @Override
    public void run(String string, String[] stringArray) {
        ChunkerCrossValidator chunkerCrossValidator;
        Object object;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        LinkedList<ChunkerEvaluationMonitor> linkedList = new LinkedList<ChunkerEvaluationMonitor>();
        ChunkerDetailedFMeasureListener chunkerDetailedFMeasureListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            linkedList.add(new ChunkEvaluationErrorListener());
        }
        if (((CVToolParams)this.params).getDetailedF().booleanValue()) {
            chunkerDetailedFMeasureListener = new ChunkerDetailedFMeasureListener();
            linkedList.add(chunkerDetailedFMeasureListener);
        }
        try {
            object = ChunkerFactory.create(((CVToolParams)this.params).getFactory());
            chunkerCrossValidator = new ChunkerCrossValidator(this.factory.getLang(), this.mlParams, (ChunkerFactory)object, linkedList.toArray(new ChunkerEvaluationMonitor[linkedList.size()]));
            chunkerCrossValidator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        if (chunkerDetailedFMeasureListener == null) {
            object = chunkerCrossValidator.getFMeasure();
            System.out.println(((FMeasure)object).toString());
        } else {
            System.out.println(chunkerDetailedFMeasureListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

