/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.ChunkerFactory;
import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.cmdline.AbstractTrainerTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.chunker.TrainingParams;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.IOException;

public class ChunkerTrainerTool
extends AbstractTrainerTool<ChunkSample, TrainerToolParams> {
    public ChunkerTrainerTool() {
        super(ChunkSample.class, TrainerToolParams.class);
    }

    @Override
    public String getName() {
        return "ChunkerTrainerME";
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable chunker";
    }

    @Override
    public void run(String string, String[] stringArray) {
        ChunkerModel chunkerModel;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
        }
        File file = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("sentence detector model", file);
        try {
            ChunkerFactory chunkerFactory = ChunkerFactory.create(((TrainerToolParams)this.params).getFactory());
            chunkerModel = ChunkerME.train(this.factory.getLang(), (ObjectStream<ChunkSample>)this.sampleStream, this.mlParams, chunkerFactory);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("chunker", file, chunkerModel);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

