/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.namefind;

import chalk.tools.cmdline.AbstractCrossValidatorTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.namefind.NameEvaluationErrorListener;
import chalk.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import chalk.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import chalk.tools.cmdline.namefind.TrainingParams;
import chalk.tools.cmdline.params.CVParams;
import chalk.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.TokenNameFinderCrossValidator;
import chalk.tools.namefind.TokenNameFinderEvaluationMonitor;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;

public final class TokenNameFinderCrossValidatorTool
extends AbstractCrossValidatorTool<NameSample, CVToolParams> {
    public TokenNameFinderCrossValidatorTool() {
        super(NameSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable Name Finder";
    }

    @Override
    public void run(String string, String[] stringArray) {
        TokenNameFinderCrossValidator tokenNameFinderCrossValidator;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        byte[] byArray = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((CVToolParams)this.params).getFeaturegen());
        Map<String, Object> map = TokenNameFinderTrainerTool.loadResources(((CVToolParams)this.params).getResources());
        LinkedList<TokenNameFinderEvaluationMonitor> linkedList = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            linkedList.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderDetailedFMeasureListener tokenNameFinderDetailedFMeasureListener = null;
        if (((CVToolParams)this.params).getDetailedF().booleanValue()) {
            tokenNameFinderDetailedFMeasureListener = new TokenNameFinderDetailedFMeasureListener();
            linkedList.add(tokenNameFinderDetailedFMeasureListener);
        }
        try {
            tokenNameFinderCrossValidator = new TokenNameFinderCrossValidator(this.factory.getLang(), ((CVToolParams)this.params).getType(), this.mlParams, byArray, map, linkedList.toArray(new TokenNameFinderEvaluationMonitor[linkedList.size()]));
            tokenNameFinderCrossValidator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println("done");
        System.out.println();
        if (tokenNameFinderDetailedFMeasureListener == null) {
            System.out.println(tokenNameFinderCrossValidator.getFMeasure());
        } else {
            System.out.println(tokenNameFinderDetailedFMeasureListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

