/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.namefind;

import chalk.tools.cmdline.AbstractEvaluatorTool;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.namefind.NameEvaluationErrorListener;
import chalk.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import chalk.tools.cmdline.namefind.TokenNameFinderModelLoader;
import chalk.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import chalk.tools.cmdline.params.EvaluatorParams;
import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.TokenNameFinderEvaluationMonitor;
import chalk.tools.namefind.TokenNameFinderEvaluator;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.util.ObjectStream;
import java.io.IOException;
import java.util.LinkedList;

public final class TokenNameFinderEvaluatorTool
extends AbstractEvaluatorTool<NameSample, EvalToolParams> {
    public TokenNameFinderEvaluatorTool() {
        super(NameSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the NameFinder model with the reference data";
    }

    @Override
    public void run(String string, String[] stringArray) {
        super.run(string, stringArray);
        TokenNameFinderModel tokenNameFinderModel = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<TokenNameFinderEvaluationMonitor> linkedList = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            linkedList.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderDetailedFMeasureListener tokenNameFinderDetailedFMeasureListener = null;
        if (((EvalToolParams)this.params).getDetailedF().booleanValue()) {
            tokenNameFinderDetailedFMeasureListener = new TokenNameFinderDetailedFMeasureListener();
            linkedList.add(tokenNameFinderDetailedFMeasureListener);
        }
        TokenNameFinderEvaluator tokenNameFinderEvaluator = new TokenNameFinderEvaluator(new NameFinderME(tokenNameFinderModel), linkedList.toArray(new TokenNameFinderEvaluationMonitor[linkedList.size()]));
        final PerformanceMonitor performanceMonitor = new PerformanceMonitor("sent");
        ObjectStream<NameSample> objectStream = new ObjectStream<NameSample>(){

            @Override
            public NameSample read() throws IOException {
                performanceMonitor.incrementCounter();
                return (NameSample)TokenNameFinderEvaluatorTool.this.sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                TokenNameFinderEvaluatorTool.this.sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                TokenNameFinderEvaluatorTool.this.sampleStream.close();
            }
        };
        performanceMonitor.startAndPrintThroughput();
        try {
            tokenNameFinderEvaluator.evaluate(objectStream);
        }
        catch (IOException iOException) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                objectStream.close();
            }
            catch (IOException iOException) {}
        }
        performanceMonitor.stopAndPrintFinalResult();
        System.out.println();
        if (tokenNameFinderDetailedFMeasureListener == null) {
            System.out.println(tokenNameFinderEvaluator.getFMeasure());
        } else {
            System.out.println(tokenNameFinderDetailedFMeasureListener.toString());
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    DetailedFMeasureEvaluatorParams {
    }
}

