/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.postag;

import chalk.tools.cmdline.AbstractCrossValidatorTool;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.CVParams;
import chalk.tools.cmdline.postag.POSEvaluationErrorListener;
import chalk.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import chalk.tools.cmdline.postag.TrainingParams;
import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSTaggerCrossValidator;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class POSTaggerCrossValidatorTool
extends AbstractCrossValidatorTool<POSSample, CVToolParams> {
    public POSTaggerCrossValidatorTool() {
        super(POSSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable POS tagger";
    }

    @Override
    public void run(String string, String[] stringArray) {
        POSTaggerCrossValidator pOSTaggerCrossValidator;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        POSEvaluationErrorListener pOSEvaluationErrorListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            pOSEvaluationErrorListener = new POSEvaluationErrorListener();
        }
        POSTaggerFineGrainedReportListener pOSTaggerFineGrainedReportListener = null;
        File file = ((CVToolParams)this.params).getReportOutputFile();
        FileOutputStream fileOutputStream = null;
        if (file != null) {
            CmdLineUtil.checkOutputFile("Report Output File", file);
            try {
                fileOutputStream = new FileOutputStream(file);
                pOSTaggerFineGrainedReportListener = new POSTaggerFineGrainedReportListener(fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TerminateToolException(-1, "IO error while creating POS Tagger fine-grained report file: " + fileNotFoundException.getMessage());
            }
        }
        try {
            pOSTaggerCrossValidator = new POSTaggerCrossValidator(this.factory.getLang(), this.mlParams, ((CVToolParams)this.params).getDict(), ((CVToolParams)this.params).getNgram(), ((CVToolParams)this.params).getTagDictCutoff(), ((CVToolParams)this.params).getFactory(), pOSEvaluationErrorListener, pOSTaggerFineGrainedReportListener);
            pOSTaggerCrossValidator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println("done");
        if (pOSTaggerFineGrainedReportListener != null) {
            System.out.println("Writing fine-grained report to " + ((CVToolParams)this.params).getReportOutputFile().getAbsolutePath());
            pOSTaggerFineGrainedReportListener.writeReport();
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println();
        System.out.println("Accuracy: " + pOSTaggerCrossValidator.getWordAccuracy());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams {
        @ArgumentParser.ParameterDescription(valueName="outputFile", description="the path of the fine-grained report file.")
        @ArgumentParser.OptionalParameter
        public File getReportOutputFile();
    }
}

