/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.sentdetect;

import chalk.tools.cmdline.AbstractCrossValidatorTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.CVParams;
import chalk.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import chalk.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import chalk.tools.cmdline.sentdetect.TrainingParams;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.sentdetect.SDCrossValidator;
import chalk.tools.sentdetect.SentenceDetectorFactory;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;

public final class SentenceDetectorCrossValidatorTool
extends AbstractCrossValidatorTool<SentenceSample, CVToolParams> {
    public SentenceDetectorCrossValidatorTool() {
        super(SentenceSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable sentence detector";
    }

    @Override
    public void run(String string, String[] stringArray) {
        SDCrossValidator sDCrossValidator;
        Object object;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        SentenceEvaluationErrorListener sentenceEvaluationErrorListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            sentenceEvaluationErrorListener = new SentenceEvaluationErrorListener();
        }
        char[] cArray = null;
        if (((CVToolParams)this.params).getEosChars() != null) {
            cArray = ((CVToolParams)this.params).getEosChars().toCharArray();
        }
        try {
            object = SentenceDetectorTrainerTool.loadDict(((CVToolParams)this.params).getAbbDict());
            SentenceDetectorFactory sentenceDetectorFactory = SentenceDetectorFactory.create(((CVToolParams)this.params).getFactory(), this.factory.getLang(), true, (Dictionary)object, cArray);
            sDCrossValidator = new SDCrossValidator(this.factory.getLang(), this.mlParams, sentenceDetectorFactory, sentenceEvaluationErrorListener);
            sDCrossValidator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        object = sDCrossValidator.getFMeasure();
        System.out.println(((FMeasure)object).toString());
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams {
    }
}

