/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.sentdetect;

import chalk.tools.cmdline.AbstractEvaluatorTool;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.EvaluatorParams;
import chalk.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import chalk.tools.cmdline.sentdetect.SentenceModelLoader;
import chalk.tools.sentdetect.SentenceDetectorEvaluator;
import chalk.tools.sentdetect.SentenceDetectorME;
import chalk.tools.sentdetect.SentenceModel;
import chalk.tools.sentdetect.SentenceSample;
import java.io.IOException;

public final class SentenceDetectorEvaluatorTool
extends AbstractEvaluatorTool<SentenceSample, EvalToolParams> {
    public SentenceDetectorEvaluatorTool() {
        super(SentenceSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "evaluator for the learnable sentence detector";
    }

    @Override
    public void run(String string, String[] stringArray) {
        super.run(string, stringArray);
        SentenceModel sentenceModel = (SentenceModel)new SentenceModelLoader().load(((EvalToolParams)this.params).getModel());
        SentenceEvaluationErrorListener sentenceEvaluationErrorListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            sentenceEvaluationErrorListener = new SentenceEvaluationErrorListener();
        }
        SentenceDetectorEvaluator sentenceDetectorEvaluator = new SentenceDetectorEvaluator(new SentenceDetectorME(sentenceModel), sentenceEvaluationErrorListener);
        System.out.print("Evaluating ... ");
        try {
            sentenceDetectorEvaluator.evaluate(this.sampleStream);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.err.println("done");
        System.out.println();
        System.out.println(sentenceDetectorEvaluator.getFMeasure());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
    }
}

