/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.sentdetect;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.sentdetect.SentenceModelLoader;
import chalk.tools.sentdetect.SentenceDetectorME;
import chalk.tools.sentdetect.SentenceModel;
import chalk.tools.util.ParagraphStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class SentenceDetectorTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable sentence detector";
    }

    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println(this.getHelp());
        } else {
            SentenceModel sentenceModel = (SentenceModel)new SentenceModelLoader().load(new File(stringArray[0]));
            SentenceDetectorME sentenceDetectorME = new SentenceDetectorME(sentenceModel);
            ParagraphStream paragraphStream = new ParagraphStream(new PlainTextByLineStream(new InputStreamReader(System.in)));
            PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "sent");
            performanceMonitor.start();
            try {
                String string;
                while ((string = (String)paragraphStream.read()) != null) {
                    String[] stringArray2;
                    for (String string2 : stringArray2 = sentenceDetectorME.sentDetect(string)) {
                        System.out.println(string2);
                    }
                    performanceMonitor.incrementCounter(stringArray2.length);
                    System.out.println();
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            performanceMonitor.stopAndPrintFinalResult();
        }
    }
}

