/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.tokenizer;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.tokenizer.DetokenizationDictionaryLoader;
import chalk.tools.tokenize.DetokenizationDictionary;
import chalk.tools.tokenize.DictionaryDetokenizer;
import chalk.tools.tokenize.WhitespaceTokenizer;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class DictionaryDetokenizerTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " detokenizerDictionary";
    }

    @Override
    public void run(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println(this.getHelp());
        } else {
            DictionaryDetokenizer dictionaryDetokenizer = new DictionaryDetokenizer((DetokenizationDictionary)new DetokenizationDictionaryLoader().load(new File(stringArray[0])));
            PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "sent");
            performanceMonitor.start();
            try {
                String string;
                while ((string = (String)plainTextByLineStream.read()) != null) {
                    String[] stringArray2 = WhitespaceTokenizer.INSTANCE.tokenize(string);
                    System.out.println(dictionaryDetokenizer.detokenize(stringArray2, null));
                    performanceMonitor.incrementCounter();
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            performanceMonitor.stopAndPrintFinalResult();
        }
    }
}

