/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.tokenizer;

import chalk.tools.cmdline.AbstractEvaluatorTool;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.EvaluatorParams;
import chalk.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import chalk.tools.cmdline.tokenizer.TokenizerModelLoader;
import chalk.tools.tokenize.TokenSample;
import chalk.tools.tokenize.TokenizerEvaluator;
import chalk.tools.tokenize.TokenizerME;
import chalk.tools.tokenize.TokenizerModel;
import java.io.IOException;

public final class TokenizerMEEvaluatorTool
extends AbstractEvaluatorTool<TokenSample, EvalToolParams> {
    public TokenizerMEEvaluatorTool() {
        super(TokenSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "evaluator for the learnable tokenizer";
    }

    @Override
    public void run(String string, String[] stringArray) {
        super.run(string, stringArray);
        TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(((EvalToolParams)this.params).getModel());
        TokenEvaluationErrorListener tokenEvaluationErrorListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            tokenEvaluationErrorListener = new TokenEvaluationErrorListener();
        }
        TokenizerEvaluator tokenizerEvaluator = new TokenizerEvaluator(new TokenizerME(tokenizerModel), tokenEvaluationErrorListener);
        System.out.print("Evaluating ... ");
        try {
            tokenizerEvaluator.evaluate(this.sampleStream);
        }
        catch (IOException iOException) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println("done");
        System.out.println();
        System.out.println(tokenizerEvaluator.getFMeasure());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
    }
}

