/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.dictionary;

import chalk.tools.dictionary.serializer.Attributes;
import chalk.tools.dictionary.serializer.DictionarySerializer;
import chalk.tools.dictionary.serializer.Entry;
import chalk.tools.dictionary.serializer.EntryInserter;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.StringList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class Dictionary
implements Iterable<StringList> {
    private Set<StringListWrapper> entrySet = new HashSet<StringListWrapper>();
    private final boolean isCaseSensitive;
    private int minTokenCount = 99999;
    private int maxTokenCount = 0;

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public Dictionary(InputStream inputStream) throws IOException, InvalidFormatException {
        this.isCaseSensitive = DictionarySerializer.create(inputStream, new EntryInserter(){

            @Override
            public void insert(Entry entry) {
                Dictionary.this.put(entry.getTokens());
            }
        });
    }

    public Dictionary(InputStream inputStream, boolean bl) throws IOException, InvalidFormatException {
        this(inputStream);
    }

    public void put(StringList stringList) {
        this.entrySet.add(new StringListWrapper(stringList));
        this.minTokenCount = Math.min(this.minTokenCount, stringList.size());
        this.maxTokenCount = Math.max(this.maxTokenCount, stringList.size());
    }

    public int getMinTokenCount() {
        return this.minTokenCount;
    }

    public int getMaxTokenCount() {
        return this.maxTokenCount;
    }

    public boolean contains(StringList stringList) {
        return this.entrySet.contains(new StringListWrapper(stringList));
    }

    public void remove(StringList stringList) {
        this.entrySet.remove(new StringListWrapper(stringList));
    }

    @Override
    public Iterator<StringList> iterator() {
        final Iterator<StringListWrapper> iterator = this.entrySet.iterator();
        return new Iterator<StringList>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public StringList next() {
                return ((StringListWrapper)iterator.next()).getStringList();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public int size() {
        return this.entrySet.size();
    }

    public void serialize(OutputStream outputStream) throws IOException {
        Iterator<Entry> iterator = new Iterator<Entry>(){
            private Iterator<StringList> dictionaryIterator;
            {
                this.dictionaryIterator = Dictionary.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.dictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList stringList = this.dictionaryIterator.next();
                return new Entry(stringList, new Attributes());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(outputStream, iterator, this.isCaseSensitive);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            bl = true;
        } else if (object instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)object;
            bl = ((Object)this.entrySet).equals(dictionary.entrySet);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return ((Object)this.entrySet).hashCode();
    }

    public String toString() {
        return this.entrySet.toString();
    }

    public static Dictionary parseOneEntryPerLine(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        Dictionary dictionary = new Dictionary();
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            if (stringArray.length <= 0) continue;
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            dictionary.put(new StringList(stringArray));
        }
        return dictionary;
    }

    public Set<String> asStringSet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator iterator = Dictionary.this.entrySet.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public String next() {
                        return ((StringListWrapper)iterator.next()).getStringList().getToken(0);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Dictionary.this.entrySet.size();
            }

            @Override
            public boolean contains(Object object) {
                boolean bl = false;
                if (object instanceof String) {
                    String string = (String)object;
                    bl = Dictionary.this.entrySet.contains(new StringListWrapper(new StringList(string)));
                }
                return bl;
            }
        };
    }

    private class StringListWrapper {
        private final StringList stringList;

        private StringListWrapper(StringList stringList) {
            this.stringList = stringList;
        }

        private StringList getStringList() {
            return this.stringList;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object == this) {
                bl = true;
            } else if (object instanceof StringListWrapper) {
                StringListWrapper stringListWrapper = (StringListWrapper)object;
                bl = Dictionary.this.isCaseSensitive ? this.stringList.equals(stringListWrapper.getStringList()) : this.stringList.compareToIgnoreCase(stringListWrapper.getStringList());
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.stringList.toString().toLowerCase().hashCode();
        }

        public String toString() {
            return this.stringList.toString();
        }
    }
}

