/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.dictionary.serializer;

import chalk.tools.dictionary.serializer.Attributes;
import chalk.tools.dictionary.serializer.Entry;
import chalk.tools.dictionary.serializer.EntryInserter;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.StringList;
import chalk.tools.util.model.UncloseableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class DictionarySerializer {
    private static final String CHARSET = "UTF-8";
    private static final String DICTIONARY_ELEMENT = "dictionary";
    private static final String ENTRY_ELEMENT = "entry";
    private static final String TOKEN_ELEMENT = "token";
    private static final String ATTRIBUTE_CASE_SENSITIVE = "case_sensitive";

    public static boolean create(InputStream inputStream, EntryInserter entryInserter) throws IOException, InvalidFormatException {
        DictionaryContenthandler dictionaryContenthandler = new DictionaryContenthandler(entryInserter);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(dictionaryContenthandler);
            xMLReader.parse(new InputSource(new UncloseableInputStream(inputStream)));
        }
        catch (SAXException sAXException) {
            throw new InvalidFormatException("The profile data stream has an invalid format!", sAXException);
        }
        return dictionaryContenthandler.mIsCaseSensitiveDictionary;
    }

    @Deprecated
    public static void serialize(OutputStream outputStream, Iterator<Entry> iterator) throws IOException {
        DictionarySerializer.serialize(outputStream, iterator, true);
    }

    public static void serialize(OutputStream outputStream, Iterator<Entry> iterator, boolean bl) throws IOException {
        TransformerHandler transformerHandler;
        StreamResult streamResult = new StreamResult(outputStream);
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            transformerHandler = sAXTransformerFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new AssertionError((Object)"The Transformer configuration must be valid!");
        }
        Transformer transformer = transformerHandler.getTransformer();
        transformer.setOutputProperty("encoding", CHARSET);
        transformer.setOutputProperty("indent", "yes");
        transformerHandler.setResult(streamResult);
        try {
            transformerHandler.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", ATTRIBUTE_CASE_SENSITIVE, "", String.valueOf(bl));
            transformerHandler.startElement("", "", DICTIONARY_ELEMENT, attributesImpl);
            while (iterator.hasNext()) {
                Entry entry = iterator.next();
                DictionarySerializer.serializeEntry(transformerHandler, entry);
            }
            transformerHandler.endElement("", "", DICTIONARY_ELEMENT);
            transformerHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Error during serialization: " + sAXException.getMessage()).initCause(sAXException);
        }
    }

    private static void serializeEntry(TransformerHandler transformerHandler, Entry entry) throws SAXException {
        Object object;
        AttributesImpl attributesImpl = new AttributesImpl();
        Object object2 = entry.getAttributes().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            attributesImpl.addAttribute("", "", (String)object, "", entry.getAttributes().getValue((String)object));
        }
        transformerHandler.startElement("", "", ENTRY_ELEMENT, attributesImpl);
        object2 = entry.getTokens();
        object = ((StringList)object2).iterator();
        while (object.hasNext()) {
            transformerHandler.startElement("", "", TOKEN_ELEMENT, new AttributesImpl());
            String string = (String)object.next();
            transformerHandler.characters(string.toCharArray(), 0, string.length());
            transformerHandler.endElement("", "", TOKEN_ELEMENT);
        }
        transformerHandler.endElement("", "", ENTRY_ELEMENT);
    }

    private static class DictionaryContenthandler
    implements ContentHandler {
        private EntryInserter mInserter;
        private boolean mIsInsideTokenElement;
        private boolean mIsCaseSensitiveDictionary;
        private List<String> mTokenList = new LinkedList<String>();
        private StringBuilder token = new StringBuilder();
        private Attributes mAttributes;

        private DictionaryContenthandler(EntryInserter entryInserter) {
            this.mInserter = entryInserter;
            this.mIsCaseSensitiveDictionary = true;
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
            if (DictionarySerializer.DICTIONARY_ELEMENT.equals(string2)) {
                this.mAttributes = new Attributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.mAttributes.setValue(attributes.getLocalName(i), attributes.getValue(i));
                }
                if (this.mAttributes.getValue(DictionarySerializer.ATTRIBUTE_CASE_SENSITIVE) != null) {
                    this.mIsCaseSensitiveDictionary = Boolean.valueOf(this.mAttributes.getValue(DictionarySerializer.ATTRIBUTE_CASE_SENSITIVE));
                }
                this.mAttributes = null;
            } else if (DictionarySerializer.ENTRY_ELEMENT.equals(string2)) {
                this.mAttributes = new Attributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.mAttributes.setValue(attributes.getLocalName(i), attributes.getValue(i));
                }
            } else if (DictionarySerializer.TOKEN_ELEMENT.equals(string2)) {
                this.mIsInsideTokenElement = true;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.mIsInsideTokenElement) {
                this.token.append(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (DictionarySerializer.TOKEN_ELEMENT.equals(string2)) {
                this.mTokenList.add(this.token.toString().trim());
                this.token.setLength(0);
                this.mIsInsideTokenElement = false;
            } else if (DictionarySerializer.ENTRY_ELEMENT.equals(string2)) {
                String[] stringArray = this.mTokenList.toArray(new String[this.mTokenList.size()]);
                Entry entry = new Entry(new StringList(stringArray), this.mAttributes);
                try {
                    this.mInserter.insert(entry);
                }
                catch (InvalidFormatException invalidFormatException) {
                    throw new SAXException("Invalid dictionary format!", invalidFormatException);
                }
                this.mTokenList.clear();
                this.mAttributes = null;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
        }
    }
}

