/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.doccat;

import chalk.tools.doccat.BagOfWordsFeatureGenerator;
import chalk.tools.doccat.DoccatModel;
import chalk.tools.doccat.DocumentCategorizer;
import chalk.tools.doccat.DocumentCategorizerContextGenerator;
import chalk.tools.doccat.DocumentCategorizerEventStream;
import chalk.tools.doccat.DocumentSample;
import chalk.tools.doccat.FeatureGenerator;
import chalk.tools.tokenize.SimpleTokenizer;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;
import java.util.HashMap;
import nak.core.ClassifierUtil;
import nak.core.LinearModel;
import nak.core.TrainUtil;
import nak.data.DataIndexer;
import nak.data.EventStream;
import nak.data.TwoPassDataIndexer;
import nak.maxent.GIS;

public class DocumentCategorizerME
implements DocumentCategorizer {
    private static FeatureGenerator defaultFeatureGenerator = new BagOfWordsFeatureGenerator();
    private LinearModel model;
    private DocumentCategorizerContextGenerator mContextGenerator;

    public DocumentCategorizerME(DoccatModel doccatModel, FeatureGenerator ... featureGeneratorArray) {
        this.model = doccatModel.getChunkerModel();
        this.mContextGenerator = new DocumentCategorizerContextGenerator(featureGeneratorArray);
    }

    public DocumentCategorizerME(DoccatModel doccatModel) {
        this(doccatModel, defaultFeatureGenerator);
    }

    @Deprecated
    public DocumentCategorizerME(LinearModel linearModel) {
        this(linearModel, new BagOfWordsFeatureGenerator());
    }

    @Deprecated
    public DocumentCategorizerME(LinearModel linearModel, FeatureGenerator ... featureGeneratorArray) {
        this.model = linearModel;
        this.mContextGenerator = new DocumentCategorizerContextGenerator(featureGeneratorArray);
    }

    @Override
    public double[] categorize(String[] stringArray) {
        return this.model.eval(this.mContextGenerator.getContext(stringArray));
    }

    @Override
    public double[] categorize(String string) {
        SimpleTokenizer simpleTokenizer = SimpleTokenizer.INSTANCE;
        return this.categorize(simpleTokenizer.tokenize(string));
    }

    @Override
    public String getBestCategory(double[] dArray) {
        return ClassifierUtil.getBestOutcome((LinearModel)this.model, (double[])dArray);
    }

    @Override
    public int getIndex(String string) {
        return this.model.getIndex(string);
    }

    @Override
    public String getCategory(int n) {
        return this.model.getOutcome(n);
    }

    @Override
    public int getNumberOfCategories() {
        return this.model.getNumOutcomes();
    }

    @Override
    public String getAllResults(double[] dArray) {
        return ClassifierUtil.getAllOutcomes((LinearModel)this.model, (double[])dArray);
    }

    @Deprecated
    public static LinearModel train(DocumentCategorizerEventStream documentCategorizerEventStream) throws IOException {
        return GIS.trainModel((int)100, (DataIndexer)new TwoPassDataIndexer((EventStream)documentCategorizerEventStream, 5));
    }

    public static DoccatModel train(String string, ObjectStream<DocumentSample> objectStream, TrainingParameters trainingParameters, FeatureGenerator ... featureGeneratorArray) throws IOException {
        if (featureGeneratorArray.length == 0) {
            featureGeneratorArray = new FeatureGenerator[]{defaultFeatureGenerator};
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LinearModel linearModel = TrainUtil.train((EventStream)new DocumentCategorizerEventStream(objectStream, featureGeneratorArray), trainingParameters.getSettings(), hashMap);
        return new DoccatModel(string, linearModel, hashMap);
    }

    public static DoccatModel train(String string, ObjectStream<DocumentSample> objectStream, int n, int n2, FeatureGenerator ... featureGeneratorArray) throws IOException {
        return DocumentCategorizerME.train(string, objectStream, ModelUtil.createTrainingParameters(n2, n), featureGeneratorArray);
    }

    public static DoccatModel train(String string, ObjectStream<DocumentSample> objectStream, int n, int n2) throws IOException {
        return DocumentCategorizerME.train(string, objectStream, n, n2, defaultFeatureGenerator);
    }

    public static DoccatModel train(String string, ObjectStream<DocumentSample> objectStream) throws IOException {
        return DocumentCategorizerME.train(string, objectStream, 5, 100, defaultFeatureGenerator);
    }
}

