/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.doccat;

import chalk.tools.tokenize.WhitespaceTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DocumentSample {
    private final String category;
    private final List<String> text;

    public DocumentSample(String string, String string2) {
        this(string, WhitespaceTokenizer.INSTANCE.tokenize(string2));
    }

    public DocumentSample(String string, String[] stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("category must not be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        this.category = string;
        this.text = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(stringArray)));
    }

    public String getCategory() {
        return this.category;
    }

    public String[] getText() {
        return this.text.toArray(new String[this.text.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.category).append('\t');
        for (String string : this.text) {
            stringBuilder.append(string).append(' ');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DocumentSample) {
            DocumentSample documentSample = (DocumentSample)object;
            return this.getCategory().equals(documentSample.getCategory()) && Arrays.equals(this.getText(), documentSample.getText());
        }
        return false;
    }
}

