/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.namefind.NameSample;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import chalk.tools.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class Conll02NameSampleStream
implements ObjectStream<NameSample> {
    public static final int GENERATE_PERSON_ENTITIES = 1;
    public static final int GENERATE_ORGANIZATION_ENTITIES = 2;
    public static final int GENERATE_LOCATION_ENTITIES = 4;
    public static final int GENERATE_MISC_ENTITIES = 8;
    public static final String DOCSTART = "-DOCSTART-";
    private final LANGUAGE lang;
    private final ObjectStream<String> lineStream;
    private final int types;

    public Conll02NameSampleStream(LANGUAGE lANGUAGE, ObjectStream<String> objectStream, int n) {
        this.lang = lANGUAGE;
        this.lineStream = objectStream;
        this.types = n;
    }

    public Conll02NameSampleStream(LANGUAGE lANGUAGE, InputStream inputStream, int n) {
        this.lang = lANGUAGE;
        try {
            this.lineStream = new PlainTextByLineStream(inputStream, "UTF-8");
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        this.types = n;
    }

    static final Span extract(int n, int n2, String string) throws InvalidFormatException {
        String string2 = string.substring(2);
        if ("PER".equals(string2)) {
            string2 = "person";
        } else if ("LOC".equals(string2)) {
            string2 = "location";
        } else if ("MISC".equals(string2)) {
            string2 = "misc";
        } else if ("ORG".equals(string2)) {
            string2 = "organization";
        } else {
            throw new InvalidFormatException("Unknown type: " + string2);
        }
        return new Span(n, n2, string2);
    }

    @Override
    public NameSample read() throws IOException {
        Object object;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        while ((string = this.lineStream.read()) != null && !StringUtil.isEmpty(string)) {
            if (LANGUAGE.NL.equals((Object)this.lang) && string.startsWith(DOCSTART)) {
                bl = true;
                continue;
            }
            object = string.split(" ");
            if (((String[])object).length == 3) {
                arrayList.add(object[0]);
                arrayList2.add(object[2]);
                continue;
            }
            throw new IOException("Expected three fields per line in training data, got " + ((String[])object).length + " for line '" + string + "'!");
        }
        if (LANGUAGE.ES.equals((Object)this.lang)) {
            bl = true;
        }
        if (arrayList.size() > 0) {
            object = new ArrayList();
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                if (string2.endsWith("PER") && (this.types & 1) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("ORG") && (this.types & 2) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("LOC") && (this.types & 4) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("MISC") && (this.types & 8) == 0) {
                    string2 = "O";
                }
                if (string2.startsWith("B-")) {
                    if (n != -1) {
                        object.add(Conll02NameSampleStream.extract(n, n2, (String)arrayList2.get(n)));
                        n = -1;
                        n2 = -1;
                    }
                    n = i;
                    n2 = i + 1;
                    continue;
                }
                if (string2.startsWith("I-")) {
                    ++n2;
                    continue;
                }
                if (string2.equals("O")) {
                    if (n == -1) continue;
                    object.add(Conll02NameSampleStream.extract(n, n2, (String)arrayList2.get(n)));
                    n = -1;
                    n2 = -1;
                    continue;
                }
                throw new IOException("Invalid tag: " + string2);
            }
            if (n != -1) {
                object.add(Conll02NameSampleStream.extract(n, n2, (String)arrayList2.get(n)));
            }
            return new NameSample(arrayList.toArray(new String[arrayList.size()]), object.toArray(new Span[object.size()]), bl);
        }
        if (string != null) {
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }

    public static enum LANGUAGE {
        NL,
        ES;

    }
}

