/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.BasicFormatParams;
import chalk.tools.formats.Conll02NameSampleStream;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.namefind.NameSample;
import chalk.tools.util.ObjectStream;

public class Conll02NameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "conll02", new Conll02NameSampleStreamFactory(Parameters.class));
    }

    protected <P> Conll02NameSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<NameSample> create(String[] stringArray) {
        Conll02NameSampleStream.LANGUAGE lANGUAGE;
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        if ("nl".equals(parameters.getLang())) {
            lANGUAGE = Conll02NameSampleStream.LANGUAGE.NL;
            this.language = parameters.getLang();
        } else if ("es".equals(parameters.getLang())) {
            lANGUAGE = Conll02NameSampleStream.LANGUAGE.ES;
            this.language = parameters.getLang();
        } else {
            throw new TerminateToolException(1, "Unsupported language: " + parameters.getLang());
        }
        int n = 0;
        if (parameters.getTypes().contains("per")) {
            n |= 1;
        }
        if (parameters.getTypes().contains("org")) {
            n |= 2;
        }
        if (parameters.getTypes().contains("loc")) {
            n |= 4;
        }
        if (parameters.getTypes().contains("misc")) {
            n |= 8;
        }
        return new Conll02NameSampleStream(lANGUAGE, CmdLineUtil.openInFile(parameters.getData()), n);
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="es|nl")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="per,loc,org,misc")
        public String getTypes();
    }
}

