/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.formats.ConllXPOSSampleStream;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.postag.POSSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ConllXPOSSampleStreamFactory
extends LanguageSampleStreamFactory<POSSample> {
    public static final String CONLLX_FORMAT = "conllx";

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, CONLLX_FORMAT, new ConllXPOSSampleStreamFactory(Parameters.class));
    }

    protected <P> ConllXPOSSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<POSSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        try {
            PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader((InputStream)CmdLineUtil.openInFile(parameters.getData()), "UTF-8"));
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
            return new ConllXPOSSampleStream(plainTextByLineStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TerminateToolException(-1, "UTF-8 encoding is not supported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    static interface Parameters
    extends LanguageFormatParams {
    }
}

