/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.util.ObjectStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class DirectorySampleStream
implements ObjectStream<File> {
    private final List<File> inputDirectories;
    private final boolean isRecursiveScan;
    private final FileFilter fileFilter;
    private Stack<File> directories = new Stack();
    private Stack<File> textFiles = new Stack();

    public DirectorySampleStream(File[] fileArray, FileFilter fileFilter, boolean bl) {
        this.fileFilter = fileFilter;
        this.isRecursiveScan = bl;
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        for (File file : fileArray) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("All passed in directories must be directories, but \"" + file.toString() + "\" is not!");
            }
            arrayList.add(file);
        }
        this.inputDirectories = Collections.unmodifiableList(arrayList);
        this.directories.addAll(this.inputDirectories);
    }

    public DirectorySampleStream(File file, FileFilter fileFilter, boolean bl) {
        this(new File[]{file}, fileFilter, bl);
    }

    @Override
    public File read() throws IOException {
        while (this.textFiles.isEmpty() && !this.directories.isEmpty()) {
            File file = this.directories.pop();
            File[] fileArray = this.fileFilter != null ? file.listFiles(this.fileFilter) : file.listFiles();
            for (File file2 : fileArray) {
                if (file2.isFile()) {
                    this.textFiles.push(file2);
                    continue;
                }
                if (!this.isRecursiveScan || !file2.isDirectory()) continue;
                this.directories.push(file2);
            }
        }
        if (!this.textFiles.isEmpty()) {
            return this.textFiles.pop();
        }
        return null;
    }

    @Override
    public void reset() {
        this.directories.clear();
        this.textFiles.clear();
        this.directories.addAll(this.inputDirectories);
    }

    @Override
    public void close() throws IOException {
    }
}

