/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.doccat.DocumentSample;
import chalk.tools.doccat.DocumentSampleStream;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.FileInputStream;

public class DocumentSampleStreamFactory
extends LanguageSampleStreamFactory<DocumentSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(DocumentSample.class, "opennlp", new DocumentSampleStreamFactory(Parameters.class));
    }

    protected <P> DocumentSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<DocumentSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        CmdLineUtil.checkInputFile("Data", parameters.getData());
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding());
        return new DocumentSampleStream(plainTextByLineStream);
    }

    static interface Parameters
    extends LanguageFormatParams {
    }
}

