/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.convert;

import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class FileToStringSampleStream
extends FilterObjectStream<File, String> {
    private final Charset encoding;

    public FileToStringSampleStream(ObjectStream<File> objectStream, Charset charset) {
        super(objectStream);
        this.encoding = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file, Charset charset) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            char[] cArray = new char[1024];
            while ((n = ((Reader)bufferedReader).read(cArray, 0, cArray.length)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        finally {
            try {
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {}
        }
        return stringBuilder.toString();
    }

    @Override
    public String read() throws IOException {
        File file = (File)this.samples.read();
        if (file != null) {
            return FileToStringSampleStream.readFile(file, this.encoding);
        }
        return null;
    }
}

