/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.namefind.NameSample;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NameSampleTypeFilter
extends FilterObjectStream<NameSample, NameSample> {
    private final Set<String> types;

    public NameSampleTypeFilter(String[] stringArray, ObjectStream<NameSample> objectStream) {
        super(objectStream);
        this.types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }

    public NameSampleTypeFilter(Set<String> set, ObjectStream<NameSample> objectStream) {
        super(objectStream);
        this.types = Collections.unmodifiableSet(new HashSet<String>(set));
    }

    @Override
    public NameSample read() throws IOException {
        NameSample nameSample = (NameSample)this.samples.read();
        if (nameSample != null) {
            ArrayList<Span> arrayList = new ArrayList<Span>();
            for (Span span : nameSample.getNames()) {
                if (!this.types.contains(span.getType())) continue;
                arrayList.add(span);
            }
            return new NameSample(nameSample.getSentence(), arrayList.toArray(new Span[arrayList.size()]), nameSample.isClearAdaptiveDataSet());
        }
        return null;
    }
}

