/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.ngram;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.dictionary.serializer.Attributes;
import chalk.tools.dictionary.serializer.DictionarySerializer;
import chalk.tools.dictionary.serializer.Entry;
import chalk.tools.dictionary.serializer.EntryInserter;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.StringList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class NGramModel
implements Iterable<StringList> {
    protected static final String COUNT = "count";
    private Map<StringList, Integer> mNGrams = new HashMap<StringList, Integer>();

    public NGramModel() {
    }

    public NGramModel(InputStream inputStream) throws IOException, InvalidFormatException {
        DictionarySerializer.create(inputStream, new EntryInserter(){

            @Override
            public void insert(Entry entry) throws InvalidFormatException {
                int n;
                String string = null;
                try {
                    string = entry.getAttributes().getValue(NGramModel.COUNT);
                    if (string == null) {
                        throw new InvalidFormatException("The count attribute must be set!");
                    }
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidFormatException("The count attribute '" + string + "' must be a number!", numberFormatException);
                }
                NGramModel.this.add(entry.getTokens());
                NGramModel.this.setCount(entry.getTokens(), n);
            }
        });
    }

    public int getCount(StringList stringList) {
        Integer n = this.mNGrams.get(stringList);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void setCount(StringList stringList, int n) {
        Integer n2 = this.mNGrams.put(stringList, n);
        if (n2 == null) {
            this.mNGrams.remove(stringList);
            throw new NoSuchElementException();
        }
    }

    public void add(StringList stringList) {
        if (this.contains(stringList)) {
            this.setCount(stringList, this.getCount(stringList) + 1);
        } else {
            this.mNGrams.put(stringList, 1);
        }
    }

    public void add(StringList stringList, int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("minLength and maxLength param must be at least 1. minLength=" + n + ", maxLength= " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("minLength param must not be larger than maxLength param. minLength=" + n + ", maxLength= " + n2);
        }
        for (int i = n; i < n2 + 1; ++i) {
            int n3 = 0;
            while (n3 + i - 1 < stringList.size()) {
                String[] stringArray = new String[i];
                for (int j = n3; j < n3 + i; ++j) {
                    stringArray[j - n3] = stringList.getToken(j);
                }
                this.add(new StringList(stringArray));
                ++n3;
            }
        }
    }

    public void add(String string, int n, int n2) {
        for (int i = n; i < n2 + 1; ++i) {
            int n3 = 0;
            while (n3 + i - 1 < string.length()) {
                String string2 = string.substring(n3, n3 + i).toLowerCase();
                this.add(new StringList(new String[]{string2}));
                ++n3;
            }
        }
    }

    public void remove(StringList stringList) {
        this.mNGrams.remove(stringList);
    }

    public boolean contains(StringList stringList) {
        return this.mNGrams.containsKey(stringList);
    }

    public int size() {
        return this.mNGrams.size();
    }

    @Override
    public Iterator<StringList> iterator() {
        return this.mNGrams.keySet().iterator();
    }

    public int numberOfGrams() {
        int n = 0;
        for (StringList stringList : this) {
            n += this.getCount(stringList);
        }
        return n;
    }

    public void cutoff(int n, int n2) {
        if (n > 0 || n2 < Integer.MAX_VALUE) {
            Iterator<StringList> iterator = this.iterator();
            while (iterator.hasNext()) {
                StringList stringList = iterator.next();
                int n3 = this.getCount(stringList);
                if (n3 >= n && n3 <= n2) continue;
                iterator.remove();
            }
        }
    }

    public Dictionary toDictionary() {
        return this.toDictionary(false);
    }

    public Dictionary toDictionary(boolean bl) {
        Dictionary dictionary = new Dictionary(bl);
        for (StringList stringList : this) {
            dictionary.put(stringList);
        }
        return dictionary;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        Iterator<Entry> iterator = new Iterator<Entry>(){
            private Iterator<StringList> mDictionaryIterator;
            {
                this.mDictionaryIterator = NGramModel.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList stringList = this.mDictionaryIterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue(NGramModel.COUNT, Integer.toString(NGramModel.this.getCount(stringList)));
                return new Entry(stringList, attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(outputStream, iterator, false);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            bl = true;
        } else if (object instanceof NGramModel) {
            NGramModel nGramModel = (NGramModel)object;
            bl = ((Object)this.mNGrams).equals(nGramModel.mNGrams);
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return "Size: " + this.size();
    }

    public int hashCode() {
        return ((Object)this.mNGrams).hashCode();
    }
}

