/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.postag.POSContextGenerator;
import chalk.tools.util.Cache;
import chalk.tools.util.StringList;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class DefaultPOSContextGenerator
implements POSContextGenerator {
    protected final String SE = "*SE*";
    protected final String SB = "*SB*";
    private static final int PREFIX_LENGTH = 4;
    private static final int SUFFIX_LENGTH = 4;
    private static Pattern hasCap = Pattern.compile("[A-Z]");
    private static Pattern hasNum = Pattern.compile("[0-9]");
    private Cache contextsCache;
    private Object wordsKey;
    private Dictionary dict;
    private String[] dictGram;

    public DefaultPOSContextGenerator(Dictionary dictionary) {
        this(0, dictionary);
    }

    public DefaultPOSContextGenerator(int n, Dictionary dictionary) {
        this.dict = dictionary;
        this.dictGram = new String[1];
        if (n > 0) {
            this.contextsCache = new Cache(n);
        }
    }

    protected static String[] getPrefixes(String string) {
        String[] stringArray = new String[4];
        int n = 4;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, Math.min(i + 1, string.length()));
        }
        return stringArray;
    }

    protected static String[] getSuffixes(String string) {
        String[] stringArray = new String[4];
        int n = 4;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(Math.max(string.length() - i - 1, 0));
        }
        return stringArray;
    }

    @Override
    public String[] getContext(int n, String[] stringArray, String[] stringArray2, Object[] objectArray) {
        return this.getContext(n, stringArray, stringArray2);
    }

    public String[] getContext(int n, Object[] objectArray, String[] stringArray) {
        String[] stringArray2;
        String[] stringArray3;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        string5 = objectArray[n].toString();
        if (objectArray.length > n + 1) {
            string7 = objectArray[n + 1].toString();
            string6 = objectArray.length > n + 2 ? objectArray[n + 2].toString() : "*SE*";
        } else {
            string7 = "*SE*";
        }
        if (n - 1 >= 0) {
            string4 = objectArray[n - 1].toString();
            string2 = stringArray[n - 1];
            if (n - 2 >= 0) {
                string3 = objectArray[n - 2].toString();
                string = stringArray[n - 2];
            } else {
                string3 = "*SB*";
            }
        } else {
            string4 = "*SB*";
        }
        String string8 = n + string2 + string;
        if (this.contextsCache != null) {
            if (this.wordsKey == objectArray) {
                stringArray3 = (String[])this.contextsCache.get(string8);
                if (stringArray3 != null) {
                    return stringArray3;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = objectArray;
            }
        }
        stringArray3 = new ArrayList();
        stringArray3.add("default");
        stringArray3.add("w=" + string5);
        this.dictGram[0] = string5;
        if (this.dict == null || !this.dict.contains(new StringList(this.dictGram))) {
            stringArray2 = DefaultPOSContextGenerator.getSuffixes(string5);
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray3.add("suf=" + stringArray2[i]);
            }
            String[] stringArray4 = DefaultPOSContextGenerator.getPrefixes(string5);
            for (int i = 0; i < stringArray4.length; ++i) {
                stringArray3.add("pre=" + stringArray4[i]);
            }
            if (string5.indexOf(45) != -1) {
                stringArray3.add("h");
            }
            if (hasCap.matcher(string5).find()) {
                stringArray3.add("c");
            }
            if (hasNum.matcher(string5).find()) {
                stringArray3.add("d");
            }
        }
        if (string4 != null) {
            stringArray3.add("p=" + string4);
            if (string2 != null) {
                stringArray3.add("t=" + string2);
            }
            if (string3 != null) {
                stringArray3.add("pp=" + string3);
                if (string != null) {
                    stringArray3.add("t2=" + string + "," + string2);
                }
            }
        }
        if (string7 != null) {
            stringArray3.add("n=" + string7);
            if (string6 != null) {
                stringArray3.add("nn=" + string6);
            }
        }
        stringArray2 = stringArray3.toArray(new String[stringArray3.size()]);
        if (this.contextsCache != null) {
            this.contextsCache.put(string8, stringArray2);
        }
        return stringArray2;
    }
}

