/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.dictionary.serializer.Attributes;
import chalk.tools.dictionary.serializer.DictionarySerializer;
import chalk.tools.dictionary.serializer.Entry;
import chalk.tools.dictionary.serializer.EntryInserter;
import chalk.tools.postag.MutableTagDictionary;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.StringList;
import chalk.tools.util.StringUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class POSDictionary
implements Iterable<String>,
MutableTagDictionary {
    private Map<String, String[]> dictionary = new HashMap<String, String[]>();
    private boolean caseSensitive = true;

    public POSDictionary() {
        this(true);
    }

    public POSDictionary(boolean bl) {
        this.caseSensitive = bl;
    }

    @Deprecated
    public POSDictionary(String string) throws IOException {
        this(string, null, true);
    }

    @Deprecated
    public POSDictionary(String string, boolean bl) throws IOException {
        this(string, null, bl);
    }

    @Deprecated
    public POSDictionary(String string, String string2, boolean bl) throws IOException {
        this(new BufferedReader(string2 == null ? new FileReader(string) : new InputStreamReader((InputStream)new FileInputStream(string), string2)), bl);
    }

    @Deprecated
    public POSDictionary(BufferedReader bufferedReader, boolean bl) throws IOException {
        this.caseSensitive = bl;
        String string = bufferedReader.readLine();
        while (string != null) {
            String[] stringArray = string.split(" ");
            String[] stringArray2 = new String[stringArray.length - 1];
            int n = stringArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i + 1];
            }
            if (bl) {
                this.dictionary.put(stringArray[0], stringArray2);
            } else {
                this.dictionary.put(StringUtil.toLowerCase(stringArray[0]), stringArray2);
            }
            string = bufferedReader.readLine();
        }
    }

    @Override
    public String[] getTags(String string) {
        if (this.caseSensitive) {
            return this.dictionary.get(string);
        }
        return this.dictionary.get(string.toLowerCase());
    }

    void addTags(String string, String ... stringArray) {
        this.put(string, stringArray);
    }

    @Override
    public Iterator<String> iterator() {
        return this.dictionary.keySet().iterator();
    }

    private static String tagsToString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public void serialize(OutputStream outputStream) throws IOException {
        Iterator<Entry> iterator = new Iterator<Entry>(){
            Iterator<String> iterator;
            {
                this.iterator = POSDictionary.this.dictionary.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Entry next() {
                String string = this.iterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue("tags", POSDictionary.tagsToString(POSDictionary.this.getTags(string)));
                return new Entry(new StringList(string), attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(outputStream, iterator, this.caseSensitive);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof POSDictionary) {
            POSDictionary pOSDictionary = (POSDictionary)object;
            if (this.dictionary.size() == pOSDictionary.dictionary.size()) {
                for (String string : this) {
                    Object[] objectArray;
                    Object[] objectArray2 = this.getTags(string);
                    if (Arrays.equals(objectArray2, objectArray = pOSDictionary.getTags(string))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "POSDictionary{size=" + this.dictionary.size() + ", caseSensitive=" + this.caseSensitive + "}";
    }

    public static POSDictionary create(InputStream inputStream) throws IOException, InvalidFormatException {
        boolean bl;
        final POSDictionary pOSDictionary = new POSDictionary();
        pOSDictionary.caseSensitive = bl = DictionarySerializer.create(inputStream, new EntryInserter(){

            @Override
            public void insert(Entry entry) throws InvalidFormatException {
                String string = entry.getAttributes().getValue("tags");
                String[] stringArray = string.split(" ");
                StringList stringList = entry.getTokens();
                if (stringList.size() != 1) {
                    throw new InvalidFormatException("Each entry must have exactly one token! " + stringList);
                }
                pOSDictionary.dictionary.put(stringList.getToken(0), stringArray);
            }
        });
        if (!bl) {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            for (Map.Entry<String, String[]> entry : pOSDictionary.dictionary.entrySet()) {
                hashMap.put(StringUtil.toLowerCase(entry.getKey()), entry.getValue());
            }
            pOSDictionary.dictionary = hashMap;
        }
        return pOSDictionary;
    }

    @Override
    public String[] put(String string, String ... stringArray) {
        if (this.caseSensitive) {
            return this.dictionary.put(string, stringArray);
        }
        return this.dictionary.put(string.toLowerCase(), stringArray);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

