/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSTagger;
import chalk.tools.postag.POSTaggerEvaluationMonitor;
import chalk.tools.util.eval.Evaluator;
import chalk.tools.util.eval.Mean;

public class POSEvaluator
extends Evaluator<POSSample> {
    private POSTagger tagger;
    private Mean wordAccuracy = new Mean();

    public POSEvaluator(POSTagger pOSTagger, POSTaggerEvaluationMonitor ... pOSTaggerEvaluationMonitorArray) {
        super(pOSTaggerEvaluationMonitorArray);
        this.tagger = pOSTagger;
    }

    @Override
    protected POSSample processSample(POSSample pOSSample) {
        String[] stringArray = this.tagger.tag(pOSSample.getSentence(), (Object[])pOSSample.getAddictionalContext());
        String[] stringArray2 = pOSSample.getTags();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equals(stringArray[i])) {
                this.wordAccuracy.add(1.0);
                continue;
            }
            this.wordAccuracy.add(0.0);
        }
        return new POSSample(pOSSample.getSentence(), stringArray);
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }

    public String toString() {
        return "Accuracy:" + this.wordAccuracy.mean() + " Number of Samples: " + this.wordAccuracy.count();
    }
}

