/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.postag.POSDictionary;
import chalk.tools.postag.POSTaggerFactory;
import chalk.tools.postag.TagDictionary;
import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.model.ArtifactSerializer;
import chalk.tools.util.model.BaseModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import nak.core.LinearModel;

public final class POSModel
extends BaseModel {
    private static final String COMPONENT_NAME = "POSTaggerME";
    public static final String POS_MODEL_ENTRY_NAME = "pos.model";

    public POSModel(String string, LinearModel linearModel, POSDictionary pOSDictionary, Dictionary dictionary, Map<String, String> map) {
        this(string, linearModel, map, new POSTaggerFactory(dictionary, pOSDictionary));
    }

    public POSModel(String string, LinearModel linearModel, POSDictionary pOSDictionary, Dictionary dictionary) {
        this(string, linearModel, null, new POSTaggerFactory(dictionary, pOSDictionary));
    }

    public POSModel(String string, LinearModel linearModel, Map<String, String> map, POSTaggerFactory pOSTaggerFactory) {
        super(COMPONENT_NAME, string, map, pOSTaggerFactory);
        if (linearModel == null) {
            throw new IllegalArgumentException("The maxentPosModel param must not be null!");
        }
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, linearModel);
        this.checkArtifactMap();
    }

    public POSModel(InputStream inputStream) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, inputStream);
    }

    public POSModel(File file) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, file);
    }

    public POSModel(URL uRL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, uRL);
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return POSTaggerFactory.class;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> map) {
        super.createArtifactSerializers(map);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof LinearModel)) {
            throw new InvalidFormatException("POS model is incomplete!");
        }
    }

    public LinearModel getPosModel() {
        return (LinearModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
    }

    public POSDictionary getTagDictionary() {
        TagDictionary tagDictionary;
        if (this.getFactory() != null && (tagDictionary = this.getFactory().getTagDictionary()) != null) {
            if (tagDictionary instanceof POSDictionary) {
                return (POSDictionary)tagDictionary;
            }
            String string = tagDictionary.getClass().getCanonicalName();
            throw new IllegalStateException("Can not get a dictionary of type " + string + " using the deprecated method POSModel.getTagDictionary() " + "because it can only return dictionaries of type POSDictionary. " + "Use POSModel.getFactory().getTagDictionary() instead.");
        }
        return null;
    }

    public POSTaggerFactory getFactory() {
        return (POSTaggerFactory)this.toolFactory;
    }

    public Dictionary getNgramDictionary() {
        if (this.getFactory() != null) {
            return this.getFactory().getDictionary();
        }
        return null;
    }
}

