/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.tokenize.WhitespaceTokenizer;
import chalk.tools.util.InvalidFormatException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class POSSample {
    private List<String> sentence;
    private List<String> tags;
    private final String[][] additionalContext;

    public POSSample(String[] stringArray, String[] stringArray2) {
        this(stringArray, stringArray2, (String[][])null);
    }

    public POSSample(List<String> list, List<String> list2) {
        this(list, list2, (String[][])null);
    }

    public POSSample(List<String> list, List<String> list2, String[][] stringArray) {
        String[][] stringArray2;
        this.sentence = Collections.unmodifiableList(list);
        this.tags = Collections.unmodifiableList(list2);
        this.checkArguments();
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = new String[stringArray[i].length];
                System.arraycopy(stringArray[i], 0, stringArray2[i], 0, stringArray[i].length);
            }
        } else {
            stringArray2 = null;
        }
        this.additionalContext = stringArray2;
    }

    public POSSample(String[] stringArray, String[] stringArray2, String[][] stringArray3) {
        this(Arrays.asList(stringArray), Arrays.asList(stringArray2), stringArray3);
    }

    private void checkArguments() {
        if (this.sentence.size() != this.tags.size()) {
            throw new IllegalArgumentException("There must be exactly one tag for each token. tokens: " + this.sentence.size() + ", tags: " + this.tags.size());
        }
        if (this.sentence.contains(null)) {
            throw new IllegalArgumentException("null elements are not allowed in sentence tokens!");
        }
        if (this.tags.contains(null)) {
            throw new IllegalArgumentException("null elements are not allowed in tags!");
        }
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[][] getAddictionalContext() {
        return this.additionalContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getSentence().length; ++i) {
            stringBuilder.append(this.getSentence()[i]);
            stringBuilder.append('_');
            stringBuilder.append(this.getTags()[i]);
            stringBuilder.append(' ');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static POSSample parse(String string) throws InvalidFormatException {
        String[] stringArray = WhitespaceTokenizer.INSTANCE.tokenize(string);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf("_");
            if (n == -1) {
                throw new InvalidFormatException("Cannot find \"_\" inside token '" + stringArray[i] + "'!");
            }
            stringArray2[i] = stringArray[i].substring(0, n);
            stringArray3[i] = stringArray[i].substring(n + 1);
        }
        return new POSSample(stringArray2, stringArray3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof POSSample) {
            POSSample pOSSample = (POSSample)object;
            return Arrays.equals(this.getSentence(), pOSSample.getSentence()) && Arrays.equals(this.getTags(), pOSSample.getTags());
        }
        return false;
    }
}

