/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.postag.DefaultPOSContextGenerator;
import chalk.tools.postag.DefaultPOSSequenceValidator;
import chalk.tools.postag.POSContextGenerator;
import chalk.tools.postag.POSDictionary;
import chalk.tools.postag.TagDictionary;
import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.SequenceValidator;
import chalk.tools.util.ext.ExtensionLoader;
import chalk.tools.util.model.ArtifactSerializer;
import chalk.tools.util.model.UncloseableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import nak.core.AbstractModel;

public class POSTaggerFactory
extends BaseToolFactory {
    private static final String TAG_DICTIONARY_ENTRY_NAME = "tags.tagdict";
    private static final String NGRAM_DICTIONARY_ENTRY_NAME = "ngram.dictionary";
    protected Dictionary ngramDictionary;
    protected TagDictionary posDictionary;

    public POSTaggerFactory() {
    }

    public POSTaggerFactory(Dictionary dictionary, TagDictionary tagDictionary) {
        this.init(dictionary, tagDictionary);
    }

    protected void init(Dictionary dictionary, TagDictionary tagDictionary) {
        this.ngramDictionary = dictionary;
        this.posDictionary = tagDictionary;
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> map = super.createArtifactSerializersMap();
        POSDictionarySerializer.register(map);
        return map;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> map = super.createArtifactMap();
        if (this.posDictionary != null) {
            map.put(TAG_DICTIONARY_ENTRY_NAME, this.posDictionary);
        }
        if (this.ngramDictionary != null) {
            map.put(NGRAM_DICTIONARY_ENTRY_NAME, this.ngramDictionary);
        }
        return map;
    }

    public TagDictionary createTagDictionary(File file) throws InvalidFormatException, FileNotFoundException, IOException {
        return this.createTagDictionary(new FileInputStream(file));
    }

    public TagDictionary createTagDictionary(InputStream inputStream) throws InvalidFormatException, IOException {
        return POSDictionary.create(inputStream);
    }

    public void setTagDictionary(TagDictionary tagDictionary) {
        if (this.artifactProvider != null) {
            throw new IllegalStateException("Can not set tag dictionary while using artifact provider.");
        }
        this.posDictionary = tagDictionary;
    }

    public TagDictionary getTagDictionary() {
        if (this.posDictionary == null && this.artifactProvider != null) {
            this.posDictionary = (TagDictionary)this.artifactProvider.getArtifact(TAG_DICTIONARY_ENTRY_NAME);
        }
        return this.posDictionary;
    }

    public Dictionary getDictionary() {
        if (this.ngramDictionary == null && this.artifactProvider != null) {
            this.ngramDictionary = (Dictionary)this.artifactProvider.getArtifact(NGRAM_DICTIONARY_ENTRY_NAME);
        }
        return this.ngramDictionary;
    }

    public void setDictionary(Dictionary dictionary) {
        if (this.artifactProvider != null) {
            throw new IllegalStateException("Can not set ngram dictionary while using artifact provider.");
        }
        this.ngramDictionary = dictionary;
    }

    public POSContextGenerator getPOSContextGenerator() {
        return new DefaultPOSContextGenerator(0, this.getDictionary());
    }

    public POSContextGenerator getPOSContextGenerator(int n) {
        return new DefaultPOSContextGenerator(n, this.getDictionary());
    }

    public SequenceValidator<String> getSequenceValidator() {
        return new DefaultPOSSequenceValidator(this.getTagDictionary());
    }

    protected void validatePOSDictionary(POSDictionary pOSDictionary, AbstractModel abstractModel) throws InvalidFormatException {
        HashSet hashSet = new HashSet();
        for (String string : pOSDictionary) {
            Collections.addAll(hashSet, pOSDictionary.getTags(string));
        }
        HashSet hashSet2 = new HashSet();
        for (int i = 0; i < abstractModel.getNumOutcomes(); ++i) {
            hashSet2.add(abstractModel.getOutcome(i));
        }
        if (!hashSet2.containsAll(hashSet)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : hashSet) {
                if (hashSet2.contains(string)) continue;
                stringBuilder.append(string).append(" ");
            }
            throw new InvalidFormatException("Tag dictionary contains tags which are unknown by the model! The unknown tags are: " + stringBuilder.toString());
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        Object object;
        Object t = this.artifactProvider.getArtifact(TAG_DICTIONARY_ENTRY_NAME);
        if (t != null) {
            if (t instanceof POSDictionary) {
                if (!this.artifactProvider.isLoadedFromSerialized()) {
                    object = (AbstractModel)this.artifactProvider.getArtifact("pos.model");
                    POSDictionary pOSDictionary = (POSDictionary)t;
                    this.validatePOSDictionary(pOSDictionary, (AbstractModel)object);
                }
            } else {
                throw new InvalidFormatException("POSTag dictionary has wrong type!");
            }
        }
        if ((object = this.artifactProvider.getArtifact(NGRAM_DICTIONARY_ENTRY_NAME)) != null && !(object instanceof Dictionary)) {
            throw new InvalidFormatException("NGram dictionary has wrong type!");
        }
    }

    public static POSTaggerFactory create(String string, Dictionary dictionary, TagDictionary tagDictionary) throws InvalidFormatException {
        if (string == null) {
            return new POSTaggerFactory(dictionary, tagDictionary);
        }
        try {
            POSTaggerFactory pOSTaggerFactory = ExtensionLoader.instantiateExtension(POSTaggerFactory.class, string);
            pOSTaggerFactory.init(dictionary, tagDictionary);
            return pOSTaggerFactory;
        }
        catch (Exception exception) {
            String string2 = "Could not instantiate the " + string + ". The initialization throw an exception.";
            System.err.println(string2);
            exception.printStackTrace();
            throw new InvalidFormatException(string2, exception);
        }
    }

    public TagDictionary createEmptyTagDictionary() {
        this.posDictionary = new POSDictionary(true);
        return this.posDictionary;
    }

    static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        POSDictionarySerializer() {
        }

        @Override
        public POSDictionary create(InputStream inputStream) throws IOException, InvalidFormatException {
            return POSDictionary.create(new UncloseableInputStream(inputStream));
        }

        @Override
        public void serialize(POSDictionary pOSDictionary, OutputStream outputStream) throws IOException {
            pOSDictionary.serialize(outputStream);
        }

        static void register(Map<String, ArtifactSerializer> map) {
            map.put("tagdict", new POSDictionarySerializer());
        }
    }
}

