/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.ngram.NGramModel;
import chalk.tools.postag.DefaultPOSContextGenerator;
import chalk.tools.postag.MutableTagDictionary;
import chalk.tools.postag.POSContextGenerator;
import chalk.tools.postag.POSDictionary;
import chalk.tools.postag.POSModel;
import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSSampleEventStream;
import chalk.tools.postag.POSSampleSequenceStream;
import chalk.tools.postag.POSTagger;
import chalk.tools.postag.POSTaggerFactory;
import chalk.tools.postag.TagDictionary;
import chalk.tools.util.BeamSearch;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Sequence;
import chalk.tools.util.SequenceValidator;
import chalk.tools.util.StringList;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.featuregen.StringPattern;
import chalk.tools.util.model.ModelType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import nak.core.LinearModel;
import nak.core.TrainUtil;
import nak.data.EventStream;
import nak.data.SequenceStream;

public class POSTaggerME
implements POSTagger {
    protected LinearModel posModel;
    protected POSContextGenerator contextGen;
    protected TagDictionary tagDictionary;
    protected Dictionary ngramDictionary;
    protected boolean useClosedClassTagsFilter = false;
    public static final int DEFAULT_BEAM_SIZE = 3;
    protected int size;
    private Sequence bestSequence;
    protected BeamSearch<String> beam;

    public POSTaggerME(POSModel pOSModel, int n, int n2, SequenceValidator<String> sequenceValidator) {
        POSTaggerFactory pOSTaggerFactory = pOSModel.getFactory();
        this.posModel = pOSModel.getPosModel();
        pOSModel.getTagDictionary();
        this.contextGen = pOSTaggerFactory.getPOSContextGenerator(n);
        this.tagDictionary = pOSTaggerFactory.getTagDictionary();
        this.size = n;
        this.beam = new BeamSearch<String>(this.size, this.contextGen, this.posModel, sequenceValidator, n2);
    }

    public POSTaggerME(POSModel pOSModel, int n, int n2) {
        POSTaggerFactory pOSTaggerFactory = pOSModel.getFactory();
        this.posModel = pOSModel.getPosModel();
        this.contextGen = pOSTaggerFactory.getPOSContextGenerator(n);
        this.tagDictionary = pOSTaggerFactory.getTagDictionary();
        this.size = n;
        this.beam = new BeamSearch<String>(this.size, this.contextGen, this.posModel, pOSTaggerFactory.getSequenceValidator(), n2);
    }

    public POSTaggerME(POSModel pOSModel) {
        this(pOSModel, 3, 0);
    }

    @Deprecated
    public POSTaggerME(LinearModel linearModel, TagDictionary tagDictionary) {
        this(linearModel, new DefaultPOSContextGenerator(null), tagDictionary);
    }

    @Deprecated
    public POSTaggerME(LinearModel linearModel, Dictionary dictionary) {
        this(linearModel, new DefaultPOSContextGenerator(dictionary));
    }

    @Deprecated
    public POSTaggerME(LinearModel linearModel, Dictionary dictionary, TagDictionary tagDictionary) {
        this(3, linearModel, new DefaultPOSContextGenerator(dictionary), tagDictionary);
    }

    @Deprecated
    public POSTaggerME(LinearModel linearModel, POSContextGenerator pOSContextGenerator) {
        this(3, linearModel, pOSContextGenerator, null);
    }

    @Deprecated
    public POSTaggerME(LinearModel linearModel, POSContextGenerator pOSContextGenerator, TagDictionary tagDictionary) {
        this(3, linearModel, pOSContextGenerator, tagDictionary);
    }

    @Deprecated
    public POSTaggerME(int n, LinearModel linearModel, POSContextGenerator pOSContextGenerator, TagDictionary tagDictionary) {
        this.size = n;
        this.posModel = linearModel;
        this.contextGen = pOSContextGenerator;
        this.beam = new BeamSearch<String>(this.size, pOSContextGenerator, linearModel);
        this.tagDictionary = tagDictionary;
    }

    public int getNumTags() {
        return this.posModel.getNumOutcomes();
    }

    @Override
    @Deprecated
    public List<String> tag(List<String> list) {
        this.bestSequence = this.beam.bestSequence((String[])list.toArray(new String[list.size()]), null);
        return this.bestSequence.getOutcomes();
    }

    @Override
    public String[] tag(String[] stringArray) {
        return this.tag(stringArray, null);
    }

    @Override
    public String[] tag(String[] stringArray, Object[] objectArray) {
        this.bestSequence = this.beam.bestSequence((String[])stringArray, objectArray);
        List<String> list = this.bestSequence.getOutcomes();
        return list.toArray(new String[list.size()]);
    }

    public String[][] tag(int n, String[] stringArray) {
        Sequence[] sequenceArray = this.beam.bestSequences(n, (String[])stringArray, null);
        String[][] stringArray2 = new String[sequenceArray.length][];
        for (int i = 0; i < stringArray2.length; ++i) {
            List<String> list = sequenceArray[i].getOutcomes();
            stringArray2[i] = list.toArray(new String[list.size()]);
        }
        return stringArray2;
    }

    @Override
    @Deprecated
    public Sequence[] topKSequences(List<String> list) {
        return this.beam.bestSequences(this.size, (String[])list.toArray(new String[list.size()]), null);
    }

    @Override
    public Sequence[] topKSequences(String[] stringArray) {
        return this.topKSequences(stringArray, null);
    }

    @Override
    public Sequence[] topKSequences(String[] stringArray, Object[] objectArray) {
        return this.beam.bestSequences(this.size, (String[])stringArray, objectArray);
    }

    public void probs(double[] dArray) {
        this.bestSequence.getProbs(dArray);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    @Override
    @Deprecated
    public String tag(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        List<String> list = this.tag(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append((String)arrayList.get(i) + "/" + list.get(i) + " ");
        }
        return stringBuilder.toString().trim();
    }

    public String[] getOrderedTags(List<String> list, List<String> list2, int n) {
        return this.getOrderedTags(list, list2, n, null);
    }

    public String[] getOrderedTags(List<String> list, List<String> list2, int n, double[] dArray) {
        double[] dArray2 = this.posModel.eval(this.contextGen.getContext(n, list.toArray(new String[list.size()]), list2.toArray(new String[list2.size()]), (Object[])null));
        String[] stringArray = new String[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            int n2 = 0;
            for (int j = 1; j < dArray2.length; ++j) {
                if (!(dArray2[j] > dArray2[n2])) continue;
                n2 = j;
            }
            stringArray[i] = this.posModel.getOutcome(n2);
            if (dArray != null) {
                dArray[i] = dArray2[n2];
            }
            dArray2[n2] = 0.0;
        }
        return stringArray;
    }

    public static POSModel train(String string, ObjectStream<POSSample> objectStream, TrainingParameters trainingParameters, POSTaggerFactory pOSTaggerFactory) throws IOException {
        LinearModel linearModel;
        POSContextGenerator pOSContextGenerator = pOSTaggerFactory.getPOSContextGenerator();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!TrainUtil.isSequenceTraining(trainingParameters.getSettings())) {
            POSSampleEventStream pOSSampleEventStream = new POSSampleEventStream(objectStream, pOSContextGenerator);
            linearModel = TrainUtil.train((EventStream)pOSSampleEventStream, trainingParameters.getSettings(), hashMap);
        } else {
            POSSampleSequenceStream pOSSampleSequenceStream = new POSSampleSequenceStream(objectStream, pOSContextGenerator);
            linearModel = TrainUtil.train((SequenceStream)pOSSampleSequenceStream, trainingParameters.getSettings(), hashMap);
        }
        return new POSModel(string, linearModel, hashMap, pOSTaggerFactory);
    }

    public static POSModel train(String string, ObjectStream<POSSample> objectStream, TrainingParameters trainingParameters, POSDictionary pOSDictionary, Dictionary dictionary) throws IOException {
        return POSTaggerME.train(string, objectStream, trainingParameters, new POSTaggerFactory(dictionary, pOSDictionary));
    }

    @Deprecated
    public static POSModel train(String string, ObjectStream<POSSample> objectStream, ModelType modelType, POSDictionary pOSDictionary, Dictionary dictionary, int n, int n2) throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Algorithm", modelType.toString());
        trainingParameters.put("Iterations", Integer.toString(n2));
        trainingParameters.put("Cutoff", Integer.toString(n));
        return POSTaggerME.train(string, objectStream, trainingParameters, pOSDictionary, dictionary);
    }

    public static Dictionary buildNGramDictionary(ObjectStream<POSSample> objectStream, int n) throws IOException {
        POSSample pOSSample;
        NGramModel nGramModel = new NGramModel();
        while ((pOSSample = objectStream.read()) != null) {
            String[] stringArray = pOSSample.getSentence();
            if (stringArray.length <= 0) continue;
            nGramModel.add(new StringList(stringArray), 1, 1);
        }
        nGramModel.cutoff(n, Integer.MAX_VALUE);
        return nGramModel.toDictionary(true);
    }

    public static void populatePOSDictionary(ObjectStream<POSSample> objectStream, MutableTagDictionary mutableTagDictionary, int n) throws IOException {
        POSSample pOSSample;
        System.out.println("Expanding POS Dictionary ...");
        long l = System.nanoTime();
        HashMap hashMap = new HashMap();
        while ((pOSSample = objectStream.read()) != null) {
            String[] stringArray = pOSSample.getSentence();
            String[] object = pOSSample.getTags();
            for (int arrayList = 0; arrayList < stringArray.length; ++arrayList) {
                String[] stringArray2;
                if (StringPattern.recognize((String)stringArray[arrayList]).containsDigit()) continue;
                Object object2 = mutableTagDictionary.isCaseSensitive() ? stringArray[arrayList] : ((String)stringArray[arrayList]).toLowerCase();
                if (!hashMap.containsKey(object2)) {
                    hashMap.put(object2, new HashMap());
                }
                if ((stringArray2 = mutableTagDictionary.getTags((String)object2)) != null) {
                    for (String string : stringArray2) {
                        Map map = (Map)hashMap.get(object2);
                        if (map.containsKey(string)) continue;
                        map.put(string, new AtomicInteger(n));
                    }
                }
                if (!((Map)hashMap.get(object2)).containsKey(object[arrayList])) {
                    ((Map)hashMap.get(object2)).put(object[arrayList], new AtomicInteger(1));
                    continue;
                }
                ((AtomicInteger)((Map)hashMap.get(object2)).get(object[arrayList])).incrementAndGet();
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (((AtomicInteger)entry2.getValue()).get() < n) continue;
                arrayList.add(entry2.getKey());
            }
            if (arrayList.size() <= 0) continue;
            mutableTagDictionary.put((String)entry.getKey(), arrayList.toArray(new String[arrayList.size()]));
        }
        System.out.println("... finished expanding POS Dictionary. [" + (System.nanoTime() - l) / 1000000L + "ms]");
    }
}

