/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.sentdetect;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.sentdetect.EndOfSentenceScanner;
import chalk.tools.sentdetect.SDContextGenerator;
import chalk.tools.sentdetect.lang.Factory;
import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ext.ExtensionLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SentenceDetectorFactory
extends BaseToolFactory {
    private String languageCode;
    private char[] eosCharacters;
    private Dictionary abbreviationDictionary;
    private Boolean useTokenEnd = null;
    private static final String ABBREVIATIONS_ENTRY_NAME = "abbreviations.dictionary";
    private static final String EOS_CHARACTERS_PROPERTY = "eosCharacters";
    private static final String TOKEN_END_PROPERTY = "useTokenEnd";

    public SentenceDetectorFactory() {
    }

    public SentenceDetectorFactory(String string, boolean bl, Dictionary dictionary, char[] cArray) {
        this.init(string, bl, dictionary, cArray);
    }

    protected void init(String string, boolean bl, Dictionary dictionary, char[] cArray) {
        this.languageCode = string;
        this.useTokenEnd = bl;
        this.eosCharacters = cArray;
        this.abbreviationDictionary = dictionary;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        if (this.artifactProvider.getManifestProperty(TOKEN_END_PROPERTY) == null) {
            throw new InvalidFormatException("useTokenEnd is a mandatory property!");
        }
        Object t = this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        if (t != null && !(t instanceof Dictionary)) {
            throw new InvalidFormatException("Abbreviations dictionary '" + t + "' has wrong type, needs to be of type Dictionary!");
        }
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> map = super.createArtifactMap();
        if (this.abbreviationDictionary != null) {
            map.put(ABBREVIATIONS_ENTRY_NAME, this.abbreviationDictionary);
        }
        return map;
    }

    @Override
    public Map<String, String> createManifestEntries() {
        Map<String, String> map = super.createManifestEntries();
        map.put(TOKEN_END_PROPERTY, Boolean.toString(this.isUseTokenEnd()));
        if (this.getEOSCharacters() != null) {
            map.put(EOS_CHARACTERS_PROPERTY, this.eosCharArrayToString(this.getEOSCharacters()));
        }
        return map;
    }

    public static SentenceDetectorFactory create(String string, String string2, boolean bl, Dictionary dictionary, char[] cArray) throws InvalidFormatException {
        if (string == null) {
            return new SentenceDetectorFactory(string2, bl, dictionary, cArray);
        }
        try {
            SentenceDetectorFactory sentenceDetectorFactory = ExtensionLoader.instantiateExtension(SentenceDetectorFactory.class, string);
            sentenceDetectorFactory.init(string2, bl, dictionary, cArray);
            return sentenceDetectorFactory;
        }
        catch (Exception exception) {
            String string3 = "Could not instantiate the " + string + ". The initialization throw an exception.";
            System.err.println(string3);
            exception.printStackTrace();
            throw new InvalidFormatException(string3, exception);
        }
    }

    public char[] getEOSCharacters() {
        if (this.eosCharacters == null) {
            if (this.artifactProvider != null) {
                String string = this.artifactProvider.getManifestProperty(EOS_CHARACTERS_PROPERTY);
                if (string != null) {
                    this.eosCharacters = this.eosStringToCharArray(string);
                }
            } else {
                Factory factory = new Factory();
                this.eosCharacters = factory.getEOSCharacters(this.languageCode);
            }
        }
        return this.eosCharacters;
    }

    public boolean isUseTokenEnd() {
        if (this.useTokenEnd == null && this.artifactProvider != null) {
            this.useTokenEnd = Boolean.valueOf(this.artifactProvider.getManifestProperty(TOKEN_END_PROPERTY));
        }
        return this.useTokenEnd;
    }

    public Dictionary getAbbreviationDictionary() {
        if (this.abbreviationDictionary == null && this.artifactProvider != null) {
            this.abbreviationDictionary = (Dictionary)this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        }
        return this.abbreviationDictionary;
    }

    public String getLanguageCode() {
        if (this.languageCode == null && this.artifactProvider != null) {
            this.languageCode = this.artifactProvider.getLanguage();
        }
        return this.languageCode;
    }

    public EndOfSentenceScanner getEndOfSentenceScanner() {
        Factory factory = new Factory();
        char[] cArray = this.getEOSCharacters();
        if (cArray != null && cArray.length > 0) {
            return factory.createEndOfSentenceScanner(cArray);
        }
        return factory.createEndOfSentenceScanner(this.languageCode);
    }

    public SDContextGenerator getSDContextGenerator() {
        Factory factory = new Factory();
        char[] cArray = this.getEOSCharacters();
        Set<String> set = null;
        Dictionary dictionary = this.getAbbreviationDictionary();
        set = dictionary != null ? dictionary.asStringSet() : Collections.emptySet();
        if (cArray != null && cArray.length > 0) {
            return factory.createSentenceContextGenerator(set, cArray);
        }
        return factory.createSentenceContextGenerator(this.languageCode, set);
    }

    private String eosCharArrayToString(char[] cArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cArray);
        return stringBuilder.toString();
    }

    private char[] eosStringToCharArray(String string) {
        return string.toCharArray();
    }
}

