/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.sentdetect;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.sentdetect.EndOfSentenceScanner;
import chalk.tools.sentdetect.SDContextGenerator;
import chalk.tools.sentdetect.SDEventStream;
import chalk.tools.sentdetect.SentenceDetector;
import chalk.tools.sentdetect.SentenceDetectorFactory;
import chalk.tools.sentdetect.SentenceModel;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.sentdetect.lang.Factory;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Span;
import chalk.tools.util.StringUtil;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import nak.core.ClassifierUtil;
import nak.core.LinearModel;
import nak.core.TrainUtil;
import nak.data.EventStream;

public class SentenceDetectorME
implements SentenceDetector {
    public static final String SPLIT = "s";
    public static final String NO_SPLIT = "n";
    private static final Double ONE = new Double(1.0);
    private LinearModel model;
    private final SDContextGenerator cgen;
    private final EndOfSentenceScanner scanner;
    private List<Double> sentProbs = new ArrayList<Double>();
    protected boolean useTokenEnd;

    public SentenceDetectorME(SentenceModel sentenceModel) {
        SentenceDetectorFactory sentenceDetectorFactory = sentenceModel.getFactory();
        this.model = sentenceModel.getLinearModel();
        this.cgen = sentenceDetectorFactory.getSDContextGenerator();
        this.scanner = sentenceDetectorFactory.getEndOfSentenceScanner();
        this.useTokenEnd = sentenceDetectorFactory.isUseTokenEnd();
    }

    public SentenceDetectorME(SentenceModel sentenceModel, Factory factory) {
        this.model = sentenceModel.getLinearModel();
        char[] cArray = sentenceModel.getEosCharacters();
        if (cArray == null) {
            this.cgen = factory.createSentenceContextGenerator(sentenceModel.getLanguage(), SentenceDetectorME.getAbbreviations(sentenceModel.getAbbreviations()));
            this.scanner = factory.createEndOfSentenceScanner(sentenceModel.getLanguage());
        } else {
            this.cgen = factory.createSentenceContextGenerator(SentenceDetectorME.getAbbreviations(sentenceModel.getAbbreviations()), cArray);
            this.scanner = factory.createEndOfSentenceScanner(cArray);
        }
        this.useTokenEnd = sentenceModel.useTokenEnd();
    }

    private static Set<String> getAbbreviations(Dictionary dictionary) {
        if (dictionary == null) {
            return Collections.emptySet();
        }
        return dictionary.asStringSet();
    }

    @Override
    public String[] sentDetect(String string) {
        String[] stringArray;
        Span[] spanArray = this.sentPosDetect(string);
        if (spanArray.length != 0) {
            stringArray = new String[spanArray.length];
            for (int i = 0; i < spanArray.length; ++i) {
                stringArray[i] = ((Object)spanArray[i].getCoveredText(string)).toString();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private int getFirstWS(String string, int n) {
        while (n < string.length() && !StringUtil.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private int getFirstNonWS(String string, int n) {
        while (n < string.length() && StringUtil.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    @Override
    public Span[] sentPosDetect(String string) {
        int n;
        int n2;
        this.sentProbs.clear();
        StringBuffer stringBuffer = new StringBuffer(string);
        List<Integer> list = this.scanner.getPositions(string);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        int n3 = list.size();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            double[] dArray;
            String string2;
            Integer n5 = list.get(i);
            n2 = n5;
            n = this.getFirstWS(string, n2 + 1);
            if (i + 1 < n3 && list.get(i + 1) < n || !(string2 = ClassifierUtil.getBestOutcome((LinearModel)this.model, (double[])(dArray = this.model.eval(this.cgen.getContext(stringBuffer, n2))))).equals(SPLIT) || !this.isAcceptableBreak(string, n4, n2)) continue;
            if (n4 != n2) {
                if (this.useTokenEnd) {
                    arrayList.add(this.getFirstNonWS(string, this.getFirstWS(string, n2 + 1)));
                } else {
                    arrayList.add(this.getFirstNonWS(string, n2));
                }
                this.sentProbs.add(dArray[this.model.getIndex(string2)]);
            }
            n4 = n2 + 1;
        }
        int[] nArray = new int[arrayList.size()];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = (Integer)arrayList.get(n3);
        }
        if (nArray.length == 0) {
            n4 = string.length();
            for (n3 = 0; n3 < string.length() && StringUtil.isWhitespace(string.charAt(n3)); ++n3) {
            }
            while (n4 > 0 && StringUtil.isWhitespace(string.charAt(n4 - 1))) {
                --n4;
            }
            if (n4 - n3 > 0) {
                this.sentProbs.add(1.0);
                return new Span[]{new Span(n3, n4)};
            }
            return new Span[0];
        }
        n3 = nArray[nArray.length - 1] != string.length() ? 1 : 0;
        Span[] spanArray = new Span[n3 != 0 ? nArray.length + 1 : nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                n2 = 0;
                while (i < nArray.length && StringUtil.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
            } else {
                n2 = nArray[i - 1];
            }
            for (n = nArray[i]; n > 0 && StringUtil.isWhitespace(string.charAt(n - 1)); --n) {
            }
            spanArray[i] = new Span(n2, n);
        }
        if (n3 != 0) {
            spanArray[spanArray.length - 1] = new Span(nArray[nArray.length - 1], string.length());
            this.sentProbs.add(ONE);
        }
        return spanArray;
    }

    public double[] getSentenceProbabilities() {
        double[] dArray = new double[this.sentProbs.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.sentProbs.get(i);
        }
        return dArray;
    }

    protected boolean isAcceptableBreak(String string, int n, int n2) {
        return true;
    }

    public static SentenceModel train(String string, ObjectStream<SentenceSample> objectStream, boolean bl, Dictionary dictionary, TrainingParameters trainingParameters) throws IOException {
        SentenceDetectorFactory sentenceDetectorFactory = new SentenceDetectorFactory(string, bl, dictionary, null);
        return SentenceDetectorME.train(string, objectStream, sentenceDetectorFactory, trainingParameters);
    }

    public static SentenceModel train(String string, ObjectStream<SentenceSample> objectStream, SentenceDetectorFactory sentenceDetectorFactory, TrainingParameters trainingParameters) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SDEventStream sDEventStream = new SDEventStream(objectStream, sentenceDetectorFactory.getSDContextGenerator(), sentenceDetectorFactory.getEndOfSentenceScanner());
        LinearModel linearModel = TrainUtil.train((EventStream)sDEventStream, trainingParameters.getSettings(), hashMap);
        return new SentenceModel(string, linearModel, hashMap, sentenceDetectorFactory);
    }

    @Deprecated
    public static SentenceModel train(String string, ObjectStream<SentenceSample> objectStream, boolean bl, Dictionary dictionary, int n, int n2) throws IOException {
        return SentenceDetectorME.train(string, objectStream, bl, dictionary, ModelUtil.createTrainingParameters(n2, n));
    }

    public static SentenceModel train(String string, ObjectStream<SentenceSample> objectStream, boolean bl, Dictionary dictionary) throws IOException {
        return SentenceDetectorME.train(string, objectStream, bl, dictionary, 5, 100);
    }
}

