/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.sentdetect.lang;

import chalk.tools.sentdetect.DefaultEndOfSentenceScanner;
import chalk.tools.sentdetect.DefaultSDContextGenerator;
import chalk.tools.sentdetect.EndOfSentenceScanner;
import chalk.tools.sentdetect.SDContextGenerator;
import chalk.tools.sentdetect.lang.th.SentenceContextGenerator;
import java.util.Collections;
import java.util.Set;

public class Factory {
    public static final char[] ptEosCharacters = new char[]{'.', '?', '!', ';', ':', '(', ')', '\u00ab', '\u00bb', '\'', '\"'};
    public static final char[] defaultEosCharacters = new char[]{'.', '!', '?'};
    public static final char[] thEosCharacters = new char[]{' ', '\n'};

    public EndOfSentenceScanner createEndOfSentenceScanner(String string) {
        if ("th".equals(string)) {
            return new DefaultEndOfSentenceScanner(new char[]{' ', '\n'});
        }
        if ("pt".equals(string)) {
            return new DefaultEndOfSentenceScanner(ptEosCharacters);
        }
        return new DefaultEndOfSentenceScanner(defaultEosCharacters);
    }

    public EndOfSentenceScanner createEndOfSentenceScanner(char[] cArray) {
        return new DefaultEndOfSentenceScanner(cArray);
    }

    public SDContextGenerator createSentenceContextGenerator(String string, Set<String> set) {
        if ("th".equals(string)) {
            return new SentenceContextGenerator();
        }
        if ("pt".equals(string)) {
            return new DefaultSDContextGenerator(set, ptEosCharacters);
        }
        return new DefaultSDContextGenerator(set, defaultEosCharacters);
    }

    public SDContextGenerator createSentenceContextGenerator(Set<String> set, char[] cArray) {
        return new DefaultSDContextGenerator(set, cArray);
    }

    public SDContextGenerator createSentenceContextGenerator(String string) {
        return this.createSentenceContextGenerator(string, Collections.<String>emptySet());
    }

    public char[] getEOSCharacters(String string) {
        if ("th".equals(string)) {
            return thEosCharacters;
        }
        if ("pt".equals(string)) {
            return ptEosCharacters;
        }
        return defaultEosCharacters;
    }
}

