/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.dictionary.serializer.Attributes;
import chalk.tools.dictionary.serializer.DictionarySerializer;
import chalk.tools.dictionary.serializer.Entry;
import chalk.tools.dictionary.serializer.EntryInserter;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.StringList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DetokenizationDictionary {
    private final Map<String, Operation> operationTable = new HashMap<String, Operation>();

    public DetokenizationDictionary(String[] stringArray, Operation[] operationArray) {
        if (stringArray.length != operationArray.length) {
            throw new IllegalArgumentException("tokens and ops must have the same length: tokens=" + stringArray.length + ", operations=" + operationArray.length + "!");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Operation operation = operationArray[i];
            if (string == null) {
                throw new IllegalArgumentException("token at index " + i + " must not be null!");
            }
            if (operation == null) {
                throw new IllegalArgumentException("operation at index " + i + " must not be null!");
            }
            this.operationTable.put(string, operation);
        }
    }

    public DetokenizationDictionary(InputStream inputStream) throws IOException, InvalidFormatException {
        DictionarySerializer.create(inputStream, new EntryInserter(){

            @Override
            public void insert(Entry entry) throws InvalidFormatException {
                String string = entry.getAttributes().getValue("operation");
                StringList stringList = entry.getTokens();
                if (stringList.size() != 1) {
                    throw new InvalidFormatException("Each entry must have exactly one token! " + stringList);
                }
                Operation operation = Operation.parse(string);
                if (operation == null) {
                    throw new InvalidFormatException("Unknown operation type: " + string);
                }
                DetokenizationDictionary.this.operationTable.put(stringList.getToken(0), operation);
            }
        });
    }

    Operation getOperation(String string) {
        return this.operationTable.get(string);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        Iterator<Entry> iterator = new Iterator<Entry>(){
            Iterator<String> iterator;
            {
                this.iterator = DetokenizationDictionary.this.operationTable.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Entry next() {
                String string = this.iterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue("operation", DetokenizationDictionary.this.getOperation(string).toString());
                return new Entry(new StringList(string), attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(outputStream, iterator, false);
    }

    public static enum Operation {
        MOVE_RIGHT,
        MOVE_LEFT,
        MOVE_BOTH,
        RIGHT_LEFT_MATCHING;


        public static Operation parse(String string) {
            if (MOVE_RIGHT.toString().equals(string)) {
                return MOVE_RIGHT;
            }
            if (MOVE_LEFT.toString().equals(string)) {
                return MOVE_LEFT;
            }
            if (MOVE_BOTH.toString().equals(string)) {
                return MOVE_BOTH;
            }
            if (RIGHT_LEFT_MATCHING.toString().equals(string)) {
                return RIGHT_LEFT_MATCHING;
            }
            return null;
        }
    }
}

