/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.tokenize.DetokenizationDictionary;
import chalk.tools.tokenize.Detokenizer;
import java.util.HashSet;

public class DictionaryDetokenizer
implements Detokenizer {
    private final DetokenizationDictionary dict;

    public DictionaryDetokenizer(DetokenizationDictionary detokenizationDictionary) {
        this.dict = detokenizationDictionary;
    }

    @Override
    public Detokenizer.DetokenizationOperation[] detokenize(String[] stringArray) {
        Detokenizer.DetokenizationOperation[] detokenizationOperationArray = new Detokenizer.DetokenizationOperation[stringArray.length];
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            DetokenizationDictionary.Operation operation = this.dict.getOperation(stringArray[i]);
            if (operation == null) {
                detokenizationOperationArray[i] = Detokenizer.DetokenizationOperation.NO_OPERATION;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_LEFT.equals((Object)operation)) {
                detokenizationOperationArray[i] = Detokenizer.DetokenizationOperation.MERGE_TO_LEFT;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_RIGHT.equals((Object)operation)) {
                detokenizationOperationArray[i] = Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_BOTH.equals((Object)operation)) {
                detokenizationOperationArray[i] = Detokenizer.DetokenizationOperation.MERGE_BOTH;
                continue;
            }
            if (DetokenizationDictionary.Operation.RIGHT_LEFT_MATCHING.equals((Object)operation)) {
                if (hashSet.contains(stringArray[i])) {
                    detokenizationOperationArray[i] = Detokenizer.DetokenizationOperation.MERGE_TO_LEFT;
                    hashSet.remove(stringArray[i]);
                    continue;
                }
                detokenizationOperationArray[i] = Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT;
                hashSet.add(stringArray[i]);
                continue;
            }
            throw new IllegalStateException("Unknown operation: " + (Object)((Object)operation));
        }
        return detokenizationOperationArray;
    }

    @Override
    public String detokenize(String[] stringArray, String string) {
        Detokenizer.DetokenizationOperation[] detokenizationOperationArray = this.detokenize(stringArray);
        if (stringArray.length != detokenizationOperationArray.length) {
            throw new IllegalArgumentException("tokens and operations array must have same length: tokens=" + stringArray.length + ", operations=" + detokenizationOperationArray.length + "!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            boolean bl2;
            stringBuilder.append(stringArray[i]);
            if (i + 1 == detokenizationOperationArray.length) {
                bl2 = false;
                bl = false;
            } else if (detokenizationOperationArray[i + 1].equals((Object)Detokenizer.DetokenizationOperation.MERGE_TO_LEFT) || detokenizationOperationArray[i + 1].equals((Object)Detokenizer.DetokenizationOperation.MERGE_BOTH)) {
                bl2 = false;
                bl = true;
            } else if (detokenizationOperationArray[i].equals((Object)Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT) || detokenizationOperationArray[i].equals((Object)Detokenizer.DetokenizationOperation.MERGE_BOTH)) {
                bl2 = false;
                bl = true;
            } else {
                bl2 = true;
                bl = false;
            }
            if (bl2) {
                stringBuilder.append(' ');
            }
            if (!bl || string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

