/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.tokenize.DefaultTokenContextGenerator;
import chalk.tools.tokenize.TokenContextGenerator;
import chalk.tools.tokenize.TokenSample;
import chalk.tools.tokenize.WhitespaceTokenizer;
import chalk.tools.tokenize.lang.Factory;
import chalk.tools.util.AbstractEventStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nak.core.Event;

public class TokSpanEventStream
extends AbstractEventStream<TokenSample> {
    private static Logger logger = Logger.getLogger(TokSpanEventStream.class.getName());
    private TokenContextGenerator cg;
    private boolean skipAlphaNumerics;
    private final Pattern alphaNumeric;

    public TokSpanEventStream(ObjectStream<TokenSample> objectStream, boolean bl, Pattern pattern, TokenContextGenerator tokenContextGenerator) {
        super(objectStream);
        this.alphaNumeric = pattern;
        this.skipAlphaNumerics = bl;
        this.cg = tokenContextGenerator;
    }

    public TokSpanEventStream(ObjectStream<TokenSample> objectStream, boolean bl, TokenContextGenerator tokenContextGenerator) {
        super(objectStream);
        Factory factory = new Factory();
        this.alphaNumeric = factory.getAlphanumeric(null);
        this.skipAlphaNumerics = bl;
        this.cg = tokenContextGenerator;
    }

    public TokSpanEventStream(ObjectStream<TokenSample> objectStream, boolean bl) {
        this(objectStream, bl, new DefaultTokenContextGenerator());
    }

    @Override
    protected Iterator<Event> createEvents(TokenSample tokenSample) {
        ArrayList<Event> arrayList = new ArrayList<Event>(50);
        Span[] spanArray = tokenSample.getTokenSpans();
        String string = tokenSample.getText();
        if (spanArray.length > 0) {
            int n = spanArray[0].getStart();
            int n2 = spanArray[spanArray.length - 1].getEnd();
            String string2 = string.substring(n, n2);
            Span[] spanArray2 = WhitespaceTokenizer.INSTANCE.tokenizePos(string2);
            int n3 = -1;
            int n4 = -1;
            Span[] spanArray3 = spanArray2;
            int n5 = spanArray3.length;
            for (int i = 0; i < n5; ++i) {
                int n6;
                Span span;
                Span span2 = span = spanArray3[i];
                String string3 = string2.substring(span2.getStart(), span2.getEnd());
                span2 = new Span(span2.getStart() + n, span2.getEnd() + n);
                if (string3.length() <= 1 || this.skipAlphaNumerics && this.alphaNumeric.matcher(string3).matches()) continue;
                boolean bl = false;
                for (n6 = n4 + 1; n6 < spanArray.length; ++n6) {
                    if (span2.contains(spanArray[n6])) {
                        if (!bl) {
                            n3 = n6;
                            bl = true;
                        }
                        n4 = n6;
                        continue;
                    }
                    if (span2.getEnd() < spanArray[n6].getEnd()) break;
                    if (spanArray[n6].getEnd() < span2.getStart() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.warning("Bad training token: " + spanArray[n6] + " cand: " + span2 + " token=" + string.substring(spanArray[n6].getStart(), spanArray[n6].getEnd()));
                }
                if (!bl) continue;
                for (n6 = n3; n6 <= n4; ++n6) {
                    Span span3 = spanArray[n6];
                    int n7 = span2.getStart();
                    for (int j = span3.getStart() + 1; j < span3.getEnd(); ++j) {
                        String[] stringArray = this.cg.getContext(string3, j - n7);
                        arrayList.add(new Event("F", stringArray));
                    }
                    if (span3.getEnd() == span2.getEnd()) continue;
                    String[] stringArray = this.cg.getContext(string3, span3.getEnd() - n7);
                    arrayList.add(new Event("T", stringArray));
                }
            }
        }
        return arrayList.iterator();
    }
}

