/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.tokenize.Detokenizer;
import chalk.tools.tokenize.WhitespaceTokenizer;
import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TokenSample {
    public static final String DEFAULT_SEPARATOR_CHARS = "<SPLIT>";
    private final String separatorChars = "<SPLIT>";
    private final String text;
    private final List<Span> tokenSpans;

    public TokenSample(String string, Span[] spanArray) {
        if (string == null) {
            throw new IllegalArgumentException("text must not be null!");
        }
        if (spanArray == null) {
            throw new IllegalArgumentException("tokenSpans must not be null! ");
        }
        this.text = string;
        this.tokenSpans = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(spanArray)));
        for (Span span : spanArray) {
            if (span.getStart() >= 0 && span.getStart() <= string.length() && span.getEnd() <= string.length() && span.getEnd() >= 0) continue;
            throw new IllegalArgumentException("Span " + span.toString() + " is out of bounds, text length: " + string.length() + "!");
        }
    }

    public TokenSample(Detokenizer detokenizer, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Detokenizer.DetokenizationOperation[] detokenizationOperationArray = detokenizer.detokenize(stringArray);
        ArrayList<Span> arrayList = new ArrayList<Span>();
        for (int i = 0; i < detokenizationOperationArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = i > 0 && !this.isMergeToRight(detokenizationOperationArray[i - 1]) && !this.isMergeToLeft(detokenizationOperationArray[i]);
            if (bl) {
                stringBuilder.append(' ');
            }
            int n = stringBuilder.length();
            stringBuilder.append(stringArray[i]);
            arrayList.add(new Span(n, stringBuilder.length()));
        }
        this.text = stringBuilder.toString();
        this.tokenSpans = Collections.unmodifiableList(arrayList);
    }

    private boolean isMergeToRight(Detokenizer.DetokenizationOperation detokenizationOperation) {
        return Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT.equals((Object)detokenizationOperation) || Detokenizer.DetokenizationOperation.MERGE_BOTH.equals((Object)detokenizationOperation);
    }

    private boolean isMergeToLeft(Detokenizer.DetokenizationOperation detokenizationOperation) {
        return Detokenizer.DetokenizationOperation.MERGE_TO_LEFT.equals((Object)detokenizationOperation) || Detokenizer.DetokenizationOperation.MERGE_BOTH.equals((Object)detokenizationOperation);
    }

    public String getText() {
        return this.text;
    }

    public Span[] getTokenSpans() {
        return this.tokenSpans.toArray(new Span[this.tokenSpans.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        for (Span span : this.tokenSpans) {
            if (n != -1) {
                String string = "";
                string = n == span.getStart() ? DEFAULT_SEPARATOR_CHARS : " ";
                stringBuilder.append(string);
            }
            stringBuilder.append(span.getCoveredText(this.text));
            n = span.getEnd();
        }
        return stringBuilder.toString();
    }

    private static void addToken(StringBuilder stringBuilder, List<Span> list, String string, boolean bl) {
        int n = stringBuilder.length();
        stringBuilder.append(string);
        int n2 = stringBuilder.length();
        list.add(new Span(n, n2));
        if (!bl) {
            stringBuilder.append(" ");
        }
    }

    public static TokenSample parse(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("sampleString must not be null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("separatorChars must not be null!");
        }
        Span[] spanArray = WhitespaceTokenizer.INSTANCE.tokenizePos(string);
        ArrayList<Span> arrayList = new ArrayList<Span>((int)((double)spanArray.length * 1.2));
        StringBuilder stringBuilder = new StringBuilder();
        for (Span span : spanArray) {
            String string3;
            String string4 = ((Object)span.getCoveredText(string)).toString();
            boolean bl = false;
            int n = 0;
            int n2 = -1;
            while ((n2 = string4.indexOf(string2, n)) > -1) {
                string3 = string4.substring(n, n2);
                TokenSample.addToken(stringBuilder, arrayList, string3, true);
                n = n2 + string2.length();
                bl = true;
            }
            if (bl) {
                string3 = string4.substring(n);
                TokenSample.addToken(stringBuilder, arrayList, string3, false);
                continue;
            }
            TokenSample.addToken(stringBuilder, arrayList, string4, false);
        }
        return new TokenSample(stringBuilder.toString(), arrayList.toArray(new Span[arrayList.size()]));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TokenSample) {
            TokenSample tokenSample = (TokenSample)object;
            return this.getText().equals(tokenSample.getText()) && Arrays.equals(this.getTokenSpans(), tokenSample.getTokenSpans());
        }
        return false;
    }
}

