/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.tokenize.TokenizerFactory;
import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.model.BaseModel;
import chalk.tools.util.model.ModelUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import nak.core.LinearModel;
import nak.io.BinaryGISModelReader;

public final class TokenizerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "TokenizerME";
    private static final String TOKENIZER_MODEL_ENTRY = "token.model";

    public TokenizerModel(LinearModel linearModel, Map<String, String> map, TokenizerFactory tokenizerFactory) {
        super(COMPONENT_NAME, tokenizerFactory.getLanguageCode(), map, tokenizerFactory);
        this.artifactMap.put(TOKENIZER_MODEL_ENTRY, linearModel);
        this.checkArtifactMap();
    }

    public TokenizerModel(String string, LinearModel linearModel, Dictionary dictionary, boolean bl, Map<String, String> map) {
        this(linearModel, map, new TokenizerFactory(string, dictionary, bl, null));
    }

    public TokenizerModel(String string, LinearModel linearModel, boolean bl, Map<String, String> map) {
        this(string, linearModel, null, bl, map);
    }

    public TokenizerModel(String string, LinearModel linearModel, boolean bl) {
        this(string, linearModel, bl, null);
    }

    public TokenizerModel(InputStream inputStream) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, inputStream);
    }

    public TokenizerModel(File file) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, file);
    }

    public TokenizerModel(URL uRL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, uRL);
    }

    private static boolean isModelCompatible(LinearModel linearModel) {
        return ModelUtil.validateOutcomes(linearModel, "T", "F");
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(TOKENIZER_MODEL_ENTRY) instanceof LinearModel)) {
            throw new InvalidFormatException("Token model is incomplete!");
        }
        if (!TokenizerModel.isModelCompatible(this.getLinearModel())) {
            throw new InvalidFormatException("The maxent model is not compatible with the tokenizer!");
        }
    }

    public TokenizerFactory getFactory() {
        return (TokenizerFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return TokenizerFactory.class;
    }

    public LinearModel getLinearModel() {
        return (LinearModel)this.artifactMap.get(TOKENIZER_MODEL_ENTRY);
    }

    public Dictionary getAbbreviations() {
        if (this.getFactory() != null) {
            return this.getFactory().getAbbreviationDictionary();
        }
        return null;
    }

    public boolean useAlphaNumericOptimization() {
        if (this.getFactory() != null) {
            return this.getFactory().isUseAlphaNumericOptmization();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 3) {
            System.err.println("TokenizerModel [-alphaNumericOptimization] languageCode packageName modelName");
            System.exit(1);
        }
        int n = 0;
        boolean bl = false;
        if ("-alphaNumericOptimization".equals(stringArray[n])) {
            bl = true;
        }
        int n2 = ++n;
        String string = stringArray[n2];
        int n3 = ++n;
        String string2 = stringArray[n3];
        String string3 = stringArray[++n];
        LinearModel linearModel = new BinaryGISModelReader(new DataInputStream(new FileInputStream(string3))).getModel();
        TokenizerModel tokenizerModel = new TokenizerModel(string, linearModel, bl);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            tokenizerModel.serialize(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }
}

