/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.tokenize.TokenSample;
import chalk.tools.tokenize.Tokenizer;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Span;
import java.io.IOException;

public class TokenizerStream
implements ObjectStream<TokenSample> {
    private Tokenizer tokenizer;
    private ObjectStream<String> input;

    public TokenizerStream(Tokenizer tokenizer, ObjectStream<String> objectStream) {
        this.tokenizer = tokenizer;
        this.input = objectStream;
    }

    @Override
    public TokenSample read() throws IOException {
        String string = this.input.read();
        if (string != null) {
            Span[] spanArray = this.tokenizer.tokenizePos(string);
            return new TokenSample(string, spanArray);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.input.reset();
    }
}

