/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.tokenize.TokenSample;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Span;
import java.io.IOException;

public class WhitespaceTokenStream
extends FilterObjectStream<TokenSample, String> {
    public WhitespaceTokenStream(ObjectStream<TokenSample> objectStream) {
        super(objectStream);
    }

    @Override
    public String read() throws IOException {
        TokenSample tokenSample = (TokenSample)this.samples.read();
        if (tokenSample != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Span span : tokenSample.getTokenSpans()) {
                stringBuilder.append(span.getCoveredText(tokenSample.getText()));
                stringBuilder.append(' ');
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

