/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import chalk.tools.util.Heap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ListHeap<E extends Comparable<E>>
implements Heap<E> {
    private List<E> list;
    private Comparator<E> comp;
    private int size;
    private E max = null;

    public ListHeap(int n, Comparator<E> comparator) {
        this.size = n;
        this.comp = comparator;
        this.list = new ArrayList(n);
    }

    public ListHeap(int n) {
        this(n, null);
    }

    private int parent(int n) {
        return (n - 1) / 2;
    }

    private int left(int n) {
        return (n + 1) * 2 - 1;
    }

    private int right(int n) {
        return (n + 1) * 2;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    private void swap(int n, int n2) {
        Comparable comparable = (Comparable)this.list.get(n);
        Comparable comparable2 = (Comparable)this.list.get(n2);
        this.list.set(n2, comparable);
        this.list.set(n, comparable2);
    }

    private boolean lt(E e, E e2) {
        if (this.comp != null) {
            return this.comp.compare(e, e2) < 0;
        }
        return e.compareTo(e2) < 0;
    }

    private boolean gt(E e, E e2) {
        if (this.comp != null) {
            return this.comp.compare(e, e2) > 0;
        }
        return e.compareTo(e2) > 0;
    }

    private void heapify(int n) {
        while (true) {
            int n2 = this.left(n);
            int n3 = this.right(n);
            int n4 = n2 < this.list.size() && this.lt((Comparable)this.list.get(n2), (Comparable)this.list.get(n)) ? n2 : n;
            if (n3 < this.list.size() && this.lt((Comparable)this.list.get(n3), (Comparable)this.list.get(n4))) {
                n4 = n3;
            }
            if (n4 == n) break;
            this.swap(n4, n);
            n = n4;
        }
    }

    @Override
    public E extract() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        Comparable comparable = (Comparable)this.list.get(0);
        int n = this.list.size() - 1;
        if (n != 0) {
            this.list.set(0, this.list.remove(n));
            this.heapify(0);
        } else {
            this.list.remove(n);
        }
        return (E)comparable;
    }

    @Override
    public E first() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        return (E)((Comparable)this.list.get(0));
    }

    @Override
    public E last() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        return this.max;
    }

    @Override
    public void add(E e) {
        if (this.max == null) {
            this.max = e;
        } else if (this.gt(e, this.max)) {
            if (this.list.size() < this.size) {
                this.max = e;
            } else {
                return;
            }
        }
        this.list.add(e);
        int n = this.list.size() - 1;
        while (n > 0 && this.gt((Comparable)this.list.get(this.parent(n)), e)) {
            this.list.set(n, this.list.get(this.parent(n)));
            n = this.parent(n);
        }
        this.list.set(n, e);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Deprecated
    public static void main(String[] stringArray) {
        ListHeap<Integer> listHeap = new ListHeap<Integer>(5);
        for (int i = 0; i < stringArray.length; ++i) {
            listHeap.add(Integer.parseInt(stringArray[i]));
        }
        while (!listHeap.isEmpty()) {
            System.out.print(listHeap.extract() + " ");
        }
        System.out.println();
    }
}

