/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import chalk.tools.util.ObjectStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class ObjectStreamUtils {
    public static <T> ObjectStream<T> createObjectStream(final T ... TArray) {
        return new ObjectStream<T>(){
            private int index = 0;

            @Override
            public T read() {
                if (this.index < TArray.length) {
                    return TArray[this.index++];
                }
                return null;
            }

            @Override
            public void reset() {
                this.index = 0;
            }

            @Override
            public void close() {
            }
        };
    }

    public static <T> ObjectStream<T> createObjectStream(final Collection<T> collection) {
        return new ObjectStream<T>(){
            private Iterator<T> iterator;
            {
                this.iterator = collection.iterator();
            }

            @Override
            public T read() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }

            @Override
            public void reset() {
                this.iterator = collection.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    public static <T> ObjectStream<T> createObjectStream(final ObjectStream<T> ... objectStreamArray) {
        for (ObjectStream<T> objectStream : objectStreamArray) {
            if (objectStream != null) continue;
            throw new NullPointerException("stream cannot be null");
        }
        return new ObjectStream<T>(){
            private int streamIndex = 0;

            @Override
            public T read() throws IOException {
                Object t = null;
                while (this.streamIndex < objectStreamArray.length && t == null) {
                    t = objectStreamArray[this.streamIndex].read();
                    if (t != null) continue;
                    ++this.streamIndex;
                }
                return t;
            }

            @Override
            public void reset() throws IOException, UnsupportedOperationException {
                this.streamIndex = 0;
                for (ObjectStream objectStream : objectStreamArray) {
                    objectStream.reset();
                }
            }

            @Override
            public void close() throws IOException {
                for (ObjectStream objectStream : objectStreamArray) {
                    objectStream.close();
                }
            }
        };
    }
}

