/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import chalk.tools.util.ObjectStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;

public class PlainTextByLineStream
implements ObjectStream<String> {
    private final FileChannel channel;
    private final String encoding;
    private BufferedReader in;

    public PlainTextByLineStream(Reader reader) {
        this.in = new BufferedReader(reader);
        this.channel = null;
        this.encoding = null;
    }

    public PlainTextByLineStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(new InputStreamReader(inputStream, string));
    }

    public PlainTextByLineStream(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public PlainTextByLineStream(FileChannel fileChannel, String string) {
        this.encoding = string;
        this.channel = fileChannel;
        this.in = new BufferedReader(Channels.newReader((ReadableByteChannel)fileChannel, this.encoding));
    }

    public PlainTextByLineStream(FileChannel fileChannel, Charset charset) {
        this(fileChannel, charset.name());
    }

    @Override
    public String read() throws IOException {
        return this.in.readLine();
    }

    @Override
    public void reset() throws IOException {
        if (this.channel == null) {
            this.in.reset();
        } else {
            this.channel.position(0L);
            this.in = new BufferedReader(Channels.newReader((ReadableByteChannel)this.channel, this.encoding));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.channel == null) {
            this.in.close();
        } else {
            this.channel.close();
        }
    }
}

