/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Sequence
implements Comparable<Sequence> {
    private double score;
    private List<String> outcomes;
    private List<Double> probs;
    private static final Double ONE = 1.0;

    public Sequence() {
        this.outcomes = new ArrayList<String>(1);
        this.probs = new ArrayList<Double>(1);
        this.score = 0.0;
    }

    public Sequence(Sequence sequence) {
        this.outcomes = new ArrayList<String>(sequence.outcomes.size() + 1);
        this.outcomes.addAll(sequence.outcomes);
        this.probs = new ArrayList<Double>(sequence.probs.size() + 1);
        this.probs.addAll(sequence.probs);
        this.score = sequence.score;
    }

    public Sequence(Sequence sequence, String string, double d) {
        this.outcomes = new ArrayList<String>(sequence.outcomes.size() + 1);
        this.outcomes.addAll(sequence.outcomes);
        this.outcomes.add(string);
        this.probs = new ArrayList<Double>(sequence.probs.size() + 1);
        this.probs.addAll(sequence.probs);
        this.probs.add(d);
        this.score = sequence.score + Math.log(d);
    }

    public Sequence(List<String> list) {
        this.outcomes = list;
        this.probs = Collections.nCopies(list.size(), ONE);
    }

    @Override
    public int compareTo(Sequence sequence) {
        if (this.score < sequence.score) {
            return 1;
        }
        if (this.score > sequence.score) {
            return -1;
        }
        return 0;
    }

    public void add(String string, double d) {
        this.outcomes.add(string);
        this.probs.add(d);
        this.score += Math.log(d);
    }

    public List<String> getOutcomes() {
        return this.outcomes;
    }

    public double[] getProbs() {
        double[] dArray = new double[this.probs.size()];
        this.getProbs(dArray);
        return dArray;
    }

    public double getScore() {
        return this.score;
    }

    public void getProbs(double[] dArray) {
        int n = this.probs.size();
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.probs.get(i);
        }
    }

    public String toString() {
        return this.score + " " + this.outcomes;
    }
}

