/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

public class Span
implements Comparable<Span> {
    private final int start;
    private final int end;
    private final String type;

    public Span(int n, int n2, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("start index must be zero or greater: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("end index must be zero or greater: " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("start index must not be larger than end index: start=" + n + ", end=" + n2);
        }
        this.start = n;
        this.end = n2;
        this.type = string;
    }

    public Span(int n, int n2) {
        this(n, n2, null);
    }

    public Span(Span span, int n) {
        this(span.start + n, span.end + n, span.getType());
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getType() {
        return this.type;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean contains(Span span) {
        return this.start <= span.getStart() && span.getEnd() <= this.end;
    }

    public boolean contains(int n) {
        return this.start <= n && n < this.end;
    }

    public boolean startsWith(Span span) {
        return this.getStart() == span.getStart() && this.contains(span);
    }

    public boolean intersects(Span span) {
        int n = span.getStart();
        return this.contains(span) || span.contains(this) || this.getStart() <= n && n < this.getEnd() || n <= this.getStart() && this.getStart() < span.getEnd();
    }

    public boolean crosses(Span span) {
        int n = span.getStart();
        return !this.contains(span) && !span.contains(this) && (this.getStart() <= n && n < this.getEnd() || n <= this.getStart() && this.getStart() < span.getEnd());
    }

    public CharSequence getCoveredText(CharSequence charSequence) {
        if (this.getEnd() > charSequence.length()) {
            throw new IllegalArgumentException("The span " + this.toString() + " is outside the given text which has length " + charSequence.length() + "!");
        }
        return charSequence.subSequence(this.getStart(), this.getEnd());
    }

    @Override
    public int compareTo(Span span) {
        if (this.getStart() < span.getStart()) {
            return -1;
        }
        if (this.getStart() == span.getStart()) {
            if (this.getEnd() > span.getEnd()) {
                return -1;
            }
            if (this.getEnd() < span.getEnd()) {
                return 1;
            }
            if (this.getType() == null && span.getType() == null) {
                return 0;
            }
            if (this.getType() != null && span.getType() != null) {
                return this.getType().compareTo(span.getType());
            }
            if (this.getType() != null) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        int n = 23;
        n = n * 37 + this.getStart();
        n = n * 37 + this.getEnd();
        n = this.getType() == null ? (n *= 37) : n * 37 + this.getType().hashCode();
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            bl = true;
        } else if (object instanceof Span) {
            Span span = (Span)object;
            bl = !(this.getStart() != span.getStart() || this.getEnd() != span.getEnd() || this.getType() != null && !this.type.equals(span.getType()) || span.getType() != null && !span.getType().equals(this.getType()));
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append("[");
        stringBuilder.append(this.getStart());
        stringBuilder.append("..");
        stringBuilder.append(this.getEnd());
        stringBuilder.append(")");
        if (this.getType() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.getType());
        }
        return stringBuilder.toString();
    }

    public static String[] spansToStrings(Span[] spanArray, CharSequence charSequence) {
        String[] stringArray = new String[spanArray.length];
        int n = spanArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((Object)spanArray[i].getCoveredText(charSequence)).toString();
        }
        return stringArray;
    }

    public static String[] spansToStrings(Span[] spanArray, String[] stringArray) {
        String[] stringArray2 = new String[spanArray.length];
        StringBuilder stringBuilder = new StringBuilder();
        int n = spanArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.setLength(0);
            for (int j = spanArray[i].getStart(); j < spanArray[i].getEnd(); ++j) {
                stringBuilder.append(stringArray[j]).append(" ");
            }
            stringArray2[i] = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return stringArray2;
    }
}

