/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.eval;

public final class FMeasure {
    private long selected;
    private long target;
    private long truePositive;

    public double getPrecisionScore() {
        return this.selected > 0L ? (double)this.truePositive / (double)this.selected : 0.0;
    }

    public double getRecallScore() {
        return this.target > 0L ? (double)this.truePositive / (double)this.target : 0.0;
    }

    public double getFMeasure() {
        if (this.getPrecisionScore() + this.getRecallScore() > 0.0) {
            return 2.0 * (this.getPrecisionScore() * this.getRecallScore()) / (this.getPrecisionScore() + this.getRecallScore());
        }
        return -1.0;
    }

    public void updateScores(Object[] objectArray, Object[] objectArray2) {
        this.truePositive += (long)FMeasure.countTruePositives(objectArray, objectArray2);
        this.selected += (long)objectArray2.length;
        this.target += (long)objectArray.length;
    }

    public void mergeInto(FMeasure fMeasure) {
        this.selected += fMeasure.selected;
        this.target += fMeasure.target;
        this.truePositive += fMeasure.truePositive;
    }

    public String toString() {
        return "Precision: " + Double.toString(this.getPrecisionScore()) + "\n" + "Recall: " + Double.toString(this.getRecallScore()) + "\n" + "F-Measure: " + Double.toString(this.getFMeasure());
    }

    static int countTruePositives(Object[] objectArray, Object[] objectArray2) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            for (int j = 0; j < objectArray2.length; ++j) {
                if (!object.equals(objectArray2[j])) continue;
                ++n;
            }
        }
        return n;
    }

    public static double precision(Object[] objectArray, Object[] objectArray2) {
        if (objectArray2.length > 0) {
            return (double)FMeasure.countTruePositives(objectArray, objectArray2) / (double)objectArray2.length;
        }
        return Double.NaN;
    }

    public static double recall(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length > 0) {
            return (double)FMeasure.countTruePositives(objectArray, objectArray2) / (double)objectArray.length;
        }
        return Double.NaN;
    }
}

