/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.ext;

import chalk.tools.util.ext.ExtensionNotLoadedException;
import chalk.tools.util.ext.OSGiExtensionLoader;

public class ExtensionLoader {
    private static boolean isOsgiAvailable = false;

    private ExtensionLoader() {
    }

    static boolean isOSGiAvailable() {
        return isOsgiAvailable;
    }

    static void setOSGiAvailable() {
        isOsgiAvailable = true;
    }

    public static <T> T instantiateExtension(Class<T> clazz, String string) {
        try {
            Class<?> clazz2 = Class.forName(string);
            if (clazz.isAssignableFrom(clazz2)) {
                try {
                    return (T)clazz2.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new ExtensionNotLoadedException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ExtensionNotLoadedException(illegalAccessException);
                }
            }
            throw new ExtensionNotLoadedException("Extension class '" + clazz2.getName() + "' needs to have type: " + clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (isOsgiAvailable) {
                OSGiExtensionLoader oSGiExtensionLoader = OSGiExtensionLoader.getInstance();
                return oSGiExtensionLoader.getExtension(clazz, string);
            }
            throw new ExtensionNotLoadedException("Unable to find implementation for " + clazz.getName() + ", the class or service " + string + " could not be located!");
        }
    }
}

