/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.featuregen;

import chalk.tools.util.featuregen.AdaptiveFeatureGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AggregatedFeatureGenerator
implements AdaptiveFeatureGenerator {
    private Collection<AdaptiveFeatureGenerator> generators;

    public AggregatedFeatureGenerator(AdaptiveFeatureGenerator ... adaptiveFeatureGeneratorArray) {
        for (AdaptiveFeatureGenerator adaptiveFeatureGenerator : adaptiveFeatureGeneratorArray) {
            if (adaptiveFeatureGenerator != null) continue;
            throw new IllegalArgumentException("null values in generators are not permitted!");
        }
        this.generators = new ArrayList<AdaptiveFeatureGenerator>(adaptiveFeatureGeneratorArray.length);
        Collections.addAll(this.generators, adaptiveFeatureGeneratorArray);
        this.generators = Collections.unmodifiableCollection(this.generators);
    }

    public AggregatedFeatureGenerator(Collection<AdaptiveFeatureGenerator> collection) {
        this(collection.toArray(new AdaptiveFeatureGenerator[collection.size()]));
    }

    @Override
    public void clearAdaptiveData() {
        for (AdaptiveFeatureGenerator adaptiveFeatureGenerator : this.generators) {
            adaptiveFeatureGenerator.clearAdaptiveData();
        }
    }

    @Override
    public void createFeatures(List<String> list, String[] stringArray, int n, String[] stringArray2) {
        for (AdaptiveFeatureGenerator adaptiveFeatureGenerator : this.generators) {
            adaptiveFeatureGenerator.createFeatures(list, stringArray, n, stringArray2);
        }
    }

    @Override
    public void updateAdaptiveData(String[] stringArray, String[] stringArray2) {
        for (AdaptiveFeatureGenerator adaptiveFeatureGenerator : this.generators) {
            adaptiveFeatureGenerator.updateAdaptiveData(stringArray, stringArray2);
        }
    }

    public Collection<AdaptiveFeatureGenerator> getGenerators() {
        return this.generators;
    }
}

