/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.featuregen;

import chalk.tools.util.Cache;
import chalk.tools.util.featuregen.AdaptiveFeatureGenerator;
import chalk.tools.util.featuregen.AggregatedFeatureGenerator;
import java.util.ArrayList;
import java.util.List;

public class CachedFeatureGenerator
implements AdaptiveFeatureGenerator {
    private final AdaptiveFeatureGenerator generator;
    private String[] prevTokens;
    private Cache contextsCache;
    private long numberOfCacheHits;
    private long numberOfCacheMisses;

    public CachedFeatureGenerator(AdaptiveFeatureGenerator ... adaptiveFeatureGeneratorArray) {
        this.generator = new AggregatedFeatureGenerator(adaptiveFeatureGeneratorArray);
        this.contextsCache = new Cache(100);
    }

    @Override
    public void createFeatures(List<String> list, String[] stringArray, int n, String[] stringArray2) {
        ArrayList<String> arrayList;
        if (stringArray == this.prevTokens) {
            arrayList = (ArrayList<String>)this.contextsCache.get(n);
            if (arrayList != null) {
                ++this.numberOfCacheHits;
                list.addAll(arrayList);
                return;
            }
        } else {
            this.contextsCache.clear();
            this.prevTokens = stringArray;
        }
        arrayList = new ArrayList<String>();
        ++this.numberOfCacheMisses;
        this.generator.createFeatures(arrayList, stringArray, n, stringArray2);
        this.contextsCache.put((Object)n, arrayList);
        list.addAll(arrayList);
    }

    @Override
    public void updateAdaptiveData(String[] stringArray, String[] stringArray2) {
        this.generator.updateAdaptiveData(stringArray, stringArray2);
    }

    @Override
    public void clearAdaptiveData() {
        this.generator.clearAdaptiveData();
    }

    public long getNumberOfCacheHits() {
        return this.numberOfCacheHits;
    }

    public long getNumberOfCacheMisses() {
        return this.numberOfCacheMisses;
    }

    public String toString() {
        return super.toString() + ": hits=" + this.numberOfCacheHits + " misses=" + this.numberOfCacheMisses + " hit%" + (this.numberOfCacheHits > 0L ? (double)this.numberOfCacheHits / (double)(this.numberOfCacheMisses + this.numberOfCacheHits) : 0.0);
    }
}

