/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.model;

import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.Version;
import chalk.tools.util.ext.ExtensionLoader;
import chalk.tools.util.model.ArtifactProvider;
import chalk.tools.util.model.ArtifactSerializer;
import chalk.tools.util.model.DictionarySerializer;
import chalk.tools.util.model.GenericModelSerializer;
import chalk.tools.util.model.PropertiesSerializer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class BaseModel
implements ArtifactProvider {
    protected static final String MANIFEST_ENTRY = "manifest.properties";
    protected static final String FACTORY_NAME = "factory";
    private static final String MANIFEST_VERSION_PROPERTY = "Manifest-Version";
    private static final String COMPONENT_NAME_PROPERTY = "Component-Name";
    private static final String VERSION_PROPERTY = "OpenNLP-Version";
    private static final String TIMESTAMP_PROPERTY = "Timestamp";
    private static final String LANGUAGE_PROPERTY = "Language";
    public static final String TRAINING_CUTOFF_PROPERTY = "Training-Cutoff";
    public static final String TRAINING_ITERATIONS_PROPERTY = "Training-Iterations";
    public static final String TRAINING_EVENTHASH_PROPERTY = "Training-Eventhash";
    private Map<String, ArtifactSerializer> artifactSerializers = new HashMap<String, ArtifactSerializer>();
    protected final Map<String, Object> artifactMap = new HashMap<String, Object>();
    protected BaseToolFactory toolFactory;
    private final String componentName;
    private Map<String, byte[]> leftoverArtifacts;
    private boolean subclassSerializersInitiated = false;
    private boolean finishedLoadingArtifacts = false;
    private final boolean isLoadedFromSerialized;

    private BaseModel(String string, boolean bl) {
        this.isLoadedFromSerialized = bl;
        if (string == null) {
            throw new IllegalArgumentException("componentName must not be null!");
        }
        this.componentName = string;
    }

    protected BaseModel(String string, String string2, Map<String, String> map, BaseToolFactory baseToolFactory) {
        this(string, false);
        if (string2 == null) {
            throw new IllegalArgumentException("languageCode must not be null!");
        }
        this.createBaseArtifactSerializers(this.artifactSerializers);
        Properties properties = new Properties();
        properties.setProperty(MANIFEST_VERSION_PROPERTY, "1.0");
        properties.setProperty(LANGUAGE_PROPERTY, string2);
        properties.setProperty(VERSION_PROPERTY, Version.currentVersion().toString());
        properties.setProperty(TIMESTAMP_PROPERTY, Long.toString(System.currentTimeMillis()));
        properties.setProperty(COMPONENT_NAME_PROPERTY, string);
        if (map != null) {
            for (Map.Entry<String, String> object : map.entrySet()) {
                properties.setProperty(object.getKey(), object.getValue());
            }
        }
        this.artifactMap.put(MANIFEST_ENTRY, properties);
        this.finishedLoadingArtifacts = true;
        if (baseToolFactory != null) {
            this.setManifestProperty(FACTORY_NAME, baseToolFactory.getClass().getCanonicalName());
            this.artifactMap.putAll(baseToolFactory.createArtifactMap());
            Map<String, String> map2 = baseToolFactory.createManifestEntries();
            for (String string3 : map2.keySet()) {
                this.setManifestProperty(string3, (String)map2.get(string3));
            }
        }
        try {
            this.initializeFactory();
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalArgumentException("Could not initialize tool factory. ", invalidFormatException);
        }
        this.loadArtifactSerializers();
    }

    protected BaseModel(String string, String string2, Map<String, String> map) {
        this(string, string2, map, null);
    }

    protected BaseModel(String string, InputStream inputStream) throws IOException, InvalidFormatException {
        this(string, true);
        if (inputStream == null) {
            throw new IllegalArgumentException("in must not be null!");
        }
        this.loadModel(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel(String string, File file) throws IOException, InvalidFormatException {
        this(string, true);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            this.loadModel(bufferedInputStream);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel(String string, URL uRL) throws IOException, InvalidFormatException {
        this(string, true);
        InputStream inputStream = uRL.openStream();
        try {
            this.loadModel(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    private void loadModel(InputStream inputStream) throws IOException, InvalidFormatException {
        ZipEntry zipEntry;
        this.createBaseArtifactSerializers(this.artifactSerializers);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        this.leftoverArtifacts = new HashMap<String, byte[]>();
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = this.getEntryExtension(zipEntry.getName());
            ArtifactSerializer artifactSerializer = this.artifactSerializers.get(string);
            if (artifactSerializer == null) {
                byte[] byArray = BaseModel.toByteArray(zipInputStream);
                this.leftoverArtifacts.put(zipEntry.getName(), byArray);
            } else {
                this.artifactMap.put(zipEntry.getName(), artifactSerializer.create(zipInputStream));
            }
            zipInputStream.closeEntry();
        }
        this.initializeFactory();
        this.loadArtifactSerializers();
        this.finishLoadingArtifacts();
        this.checkArtifactMap();
    }

    private void initializeFactory() throws InvalidFormatException {
        String string = this.getManifestProperty(FACTORY_NAME);
        if (string == null) {
            Class<? extends BaseToolFactory> clazz = this.getDefaultFactory();
            if (clazz != null) {
                this.toolFactory = BaseToolFactory.create(clazz, (ArtifactProvider)this);
            }
        } else {
            try {
                this.toolFactory = BaseToolFactory.create(string, (ArtifactProvider)this);
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new IllegalArgumentException(invalidFormatException);
            }
        }
    }

    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return null;
    }

    private void loadArtifactSerializers() {
        if (!this.subclassSerializersInitiated) {
            this.createArtifactSerializers(this.artifactSerializers);
        }
        this.subclassSerializersInitiated = true;
    }

    private void finishLoadingArtifacts() throws InvalidFormatException, IOException {
        this.finishedLoadingArtifacts = true;
        if (this.leftoverArtifacts == null || this.leftoverArtifacts.size() == 0) {
            return;
        }
        HashMap hashMap = new HashMap();
        for (String string : this.leftoverArtifacts.keySet()) {
            String string2 = this.getEntryExtension(string);
            if (!this.leftoverArtifacts.containsKey(string)) continue;
            ArtifactSerializer artifactSerializer = this.artifactSerializers.get(string2);
            if (artifactSerializer == null) {
                throw new InvalidFormatException("Unknown artifact format: " + string2);
            }
            hashMap.put(string, artifactSerializer.create(new ByteArrayInputStream(this.leftoverArtifacts.get(string))));
        }
        this.leftoverArtifacts = null;
        this.artifactMap.putAll(hashMap);
    }

    private String getEntryExtension(String string) throws InvalidFormatException {
        int n = string.lastIndexOf(46) + 1;
        if (n == -1 || n >= string.length()) {
            throw new InvalidFormatException("Entry name must have type extension: " + string);
        }
        return string.substring(n);
    }

    protected ArtifactSerializer getArtifactSerializer(String string) {
        String string2 = null;
        try {
            string2 = this.getEntryExtension(string);
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalStateException(invalidFormatException);
        }
        return this.artifactSerializers.get(string2);
    }

    protected static Map<String, ArtifactSerializer> createArtifactSerializers() {
        HashMap<String, ArtifactSerializer> hashMap = new HashMap<String, ArtifactSerializer>();
        GenericModelSerializer.register(hashMap);
        PropertiesSerializer.register(hashMap);
        DictionarySerializer.register(hashMap);
        return hashMap;
    }

    protected void createArtifactSerializers(Map<String, ArtifactSerializer> map) {
        if (this.toolFactory != null) {
            map.putAll(this.toolFactory.createArtifactSerializersMap());
        }
    }

    private void createBaseArtifactSerializers(Map<String, ArtifactSerializer> map) {
        map.putAll(BaseModel.createArtifactSerializers());
    }

    protected void validateArtifactMap() throws InvalidFormatException {
        Object object;
        if (!(this.artifactMap.get(MANIFEST_ENTRY) instanceof Properties)) {
            throw new InvalidFormatException("Missing the manifest.properties!");
        }
        String string = this.getManifestProperty(VERSION_PROPERTY);
        if (string != null) {
            try {
                object = Version.parse(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("Unable to parse model version '" + string + "'!", numberFormatException);
            }
            if (!Version.currentVersion().equals(Version.DEV_VERSION)) {
                if (Version.currentVersion().getMajor() != ((Version)object).getMajor() || Version.currentVersion().getMinor() != ((Version)object).getMinor()) {
                    throw new InvalidFormatException("Model version " + object + " is not supported by this (" + Version.currentVersion() + ") version of OpenNLP!");
                }
                if (!Version.currentVersion().isSnapshot() && ((Version)object).isSnapshot()) {
                    throw new InvalidFormatException("Model version " + object + " is a snapshot - snapshot models are not " + "supported by this non-snapshot version (" + Version.currentVersion() + ") of OpenNLP!");
                }
            }
        } else {
            throw new InvalidFormatException("Missing OpenNLP-Version property in manifest.properties!");
        }
        if (this.getManifestProperty(COMPONENT_NAME_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Component-Name property in manifest.properties!");
        }
        if (!this.getManifestProperty(COMPONENT_NAME_PROPERTY).equals(this.componentName)) {
            throw new InvalidFormatException("The " + this.componentName + " cannot load a model for the " + this.getManifestProperty(COMPONENT_NAME_PROPERTY) + "!");
        }
        if (this.getManifestProperty(LANGUAGE_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Language property in manifest.properties!");
        }
        object = this.getManifestProperty(FACTORY_NAME);
        if (object != null) {
            try {
                if (ExtensionLoader.instantiateExtension(BaseToolFactory.class, (String)object) == null) {
                    throw new InvalidFormatException("Could not load an user extension specified by the model: " + (String)object);
                }
            }
            catch (Exception exception) {
                throw new InvalidFormatException("Could not load an user extension specified by the model: " + (String)object, exception);
            }
        }
        if (this.toolFactory != null) {
            this.toolFactory.validateArtifactMap();
        }
    }

    protected void checkArtifactMap() {
        if (!this.finishedLoadingArtifacts) {
            throw new IllegalStateException("The method BaseModel.finishLoadingArtifacts(..) was not called by BaseModel sub-class.");
        }
        try {
            this.validateArtifactMap();
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalArgumentException(invalidFormatException);
        }
    }

    @Override
    public final String getManifestProperty(String string) {
        Properties properties = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        return properties.getProperty(string);
    }

    protected final void setManifestProperty(String string, String string2) {
        Properties properties = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        properties.setProperty(string, string2);
    }

    @Override
    public final String getLanguage() {
        return this.getManifestProperty(LANGUAGE_PROPERTY);
    }

    public final Version getVersion() {
        String string = this.getManifestProperty(VERSION_PROPERTY);
        return Version.parse(string);
    }

    public final void serialize(OutputStream outputStream) throws IOException {
        if (!this.subclassSerializersInitiated) {
            throw new IllegalStateException("The method BaseModel.loadArtifactSerializers() was not called by BaseModel subclass constructor.");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        for (String string : this.artifactMap.keySet()) {
            zipOutputStream.putNextEntry(new ZipEntry(string));
            ArtifactSerializer artifactSerializer = this.getArtifactSerializer(string);
            if (artifactSerializer == null) {
                throw new IllegalStateException("Missing serializer for " + string);
            }
            artifactSerializer.serialize(this.artifactMap.get(string), zipOutputStream);
            zipOutputStream.closeEntry();
        }
        zipOutputStream.finish();
        zipOutputStream.flush();
    }

    @Override
    public <T> T getArtifact(String string) {
        Object object = this.artifactMap.get(string);
        if (object == null) {
            return null;
        }
        return (T)object;
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        int n2 = 0;
        while (-1 != (n2 = inputStream.read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n += n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean isLoadedFromSerialized() {
        return this.isLoadedFromSerialized;
    }
}

